/*
 * Decompiled with CFR 0.152.
 */
package org.kuali.common.util.encrypt.openssl;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.security.Key;
import java.util.Arrays;
import javax.crypto.Cipher;
import javax.crypto.spec.IvParameterSpec;
import javax.crypto.spec.SecretKeySpec;
import org.apache.commons.io.FileUtils;
import org.apache.commons.io.IOUtils;
import org.codehaus.plexus.util.Base64;
import org.kuali.common.util.Str;
import org.kuali.common.util.base.Exceptions;
import org.kuali.common.util.base.Precondition;
import org.kuali.common.util.encrypt.Encryptor;
import org.kuali.common.util.encrypt.openssl.OpenSSL;
import org.kuali.common.util.encrypt.openssl.OpenSSLContext;
import org.kuali.common.util.encrypt.openssl.OpenSSLEncryptedContext;

public final class OpenSSLEncryptor
implements Encryptor {
    private final OpenSSLContext context;
    private final byte[] password;
    private final byte[] prefix;

    public OpenSSLEncryptor(String password) {
        this(OpenSSLContext.buildDefaultOpenSSLContext(), password);
    }

    public OpenSSLEncryptor(OpenSSLContext context, String password) {
        this.context = Precondition.checkNotNull(context, "context");
        this.password = Str.getUTF8Bytes(Precondition.checkNotNull(password, "password"));
        this.prefix = Str.getUTF8Bytes(context.getSaltPrefix());
    }

    public void encrypt(File src, File dst) {
        Precondition.checkNotNull(src, "src");
        Precondition.checkNotNull(dst, "dst");
        FileInputStream in = null;
        FileOutputStream out = null;
        try {
            in = FileUtils.openInputStream((File)src);
            out = FileUtils.openOutputStream((File)dst);
            this.encrypt(in, out);
        }
        catch (IOException e) {
            throw Exceptions.illegalState(e);
        }
        finally {
            IOUtils.closeQuietly((InputStream)in);
            IOUtils.closeQuietly((OutputStream)out);
        }
    }

    public void encrypt(InputStream in, OutputStream out) throws IOException {
        byte[] bytes = IOUtils.toByteArray((InputStream)in);
        byte[] encrypted = this.encrypt(bytes);
        byte[] base64 = Base64.encodeBase64((byte[])encrypted, (boolean)true);
        out.write(base64);
    }

    public byte[] encrypt(byte[] bytes) {
        Precondition.checkNotNull(bytes, "bytes");
        byte[] salt = OpenSSL.createSalt(this.context.getSaltSize());
        byte[] encrypted = OpenSSLEncryptor.doCipher(this.context, 1, salt, bytes, this.password);
        return OpenSSL.combineByteArrays(this.prefix, salt, encrypted);
    }

    @Override
    public String encrypt(String text) {
        Precondition.checkNotNull(text, "text");
        byte[] bytes = Str.getUTF8Bytes(text);
        byte[] encrypted = this.encrypt(bytes);
        byte[] base64 = Base64.encodeBase64((byte[])encrypted);
        return Str.getAsciiString(base64);
    }

    @Override
    public String decrypt(String text) {
        Precondition.checkNotNull(text, "text");
        byte[] bytes = Base64.decodeBase64((byte[])Str.getAsciiBytes(OpenSSL.checkBase64(text)));
        int saltOffset = this.context.getSaltPrefix().length();
        byte[] salt = Arrays.copyOfRange(bytes, saltOffset, saltOffset + this.context.getSaltSize());
        int encryptedBytesOffset = saltOffset + this.context.getSaltSize();
        byte[] encrypted = Arrays.copyOfRange(bytes, encryptedBytesOffset, bytes.length);
        byte[] decrypted = OpenSSLEncryptor.doCipher(this.context, 2, salt, encrypted, this.password);
        return Str.getUTF8String(decrypted);
    }

    protected static byte[] doCipher(OpenSSLContext context, int mode, byte[] salt, byte[] bytes, byte[] password) {
        try {
            Cipher cipher = Cipher.getInstance(context.getTransformation());
            int initVectorLength = cipher.getBlockSize();
            OpenSSLEncryptedContext oec = OpenSSL.buildEncryptedContext(context, initVectorLength, salt, password);
            SecretKeySpec key = new SecretKeySpec(OpenSSL.toByteArray(oec.getKey()), context.getAlgorithm());
            IvParameterSpec iv = new IvParameterSpec(OpenSSL.toByteArray(oec.getInitVector()));
            cipher.init(mode, (Key)key, iv);
            return cipher.doFinal(bytes);
        }
        catch (Exception e) {
            throw Exceptions.illegalState(e);
        }
    }

    public OpenSSLContext getContext() {
        return this.context;
    }
}

