/*
 * Decompiled with CFR 0.152.
 */
package org.kuali.common.util.encrypt.openssl;

import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.Lists;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.security.SecureRandom;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Random;
import org.kuali.common.util.Ascii;
import org.kuali.common.util.base.Exceptions;
import org.kuali.common.util.base.Precondition;
import org.kuali.common.util.encrypt.EncryptionContext;
import org.kuali.common.util.encrypt.openssl.OpenSSLContext;
import org.kuali.common.util.encrypt.openssl.OpenSSLEncryptedContext;
import org.kuali.common.util.encrypt.openssl.OpenSSLEncryptor;

public class OpenSSL {
    private static final Random RANDOM = new SecureRandom();
    private static final int DEFAULT_SALT_SIZE = 8;
    private static final int DEFAULT_PASSWORD_LENGTH = 22;
    private static final List<Character> DEFAULT_PASSWORD_CHARS = OpenSSL.getAlphaNumericCharacters();

    public static String generatePassword() {
        return OpenSSL.generatePassword(22);
    }

    public static String generatePassword(int length) {
        return OpenSSL.generatePassword(DEFAULT_PASSWORD_CHARS, length);
    }

    public static String generatePassword(List<Character> chars, int length) {
        return OpenSSL.generatePassword(chars, length, RANDOM);
    }

    public static String generatePassword(List<Character> chars, int length, Random random) {
        char[] buffer = new char[length];
        int size = chars.size();
        for (int i = 0; i < length; ++i) {
            buffer[i] = chars.get(random.nextInt(size)).charValue();
        }
        return new String(buffer);
    }

    public static OpenSSLEncryptor buildOpenSSLEncryptor(EncryptionContext context) {
        OpenSSLContext osc = OpenSSLContext.buildOpenSSLContext(context.getStrength());
        return new OpenSSLEncryptor(osc, context.getPassword());
    }

    public static byte[] combineByteArrays(byte[] ... arrays) {
        byte[] bytes = OpenSSL.allocateByteArray(arrays);
        int offset = 0;
        for (byte[] array : arrays) {
            offset = OpenSSL.addByteArray(bytes, array, offset);
        }
        return bytes;
    }

    public static int addByteArray(byte[] dst, byte[] src, int offset) {
        System.arraycopy(src, 0, dst, offset, src.length);
        return offset + src.length;
    }

    public static byte[] allocateByteArray(byte[] ... arrays) {
        int length = 0;
        for (byte[] array : arrays) {
            length += array.length;
        }
        return new byte[length];
    }

    public static byte[] createSalt() {
        return OpenSSL.createSalt(8);
    }

    public static byte[] createSalt(int length) {
        byte[] salt = new byte[length];
        RANDOM.nextBytes(salt);
        return salt;
    }

    public static final byte[] toByteArray(List<Byte> bytes) {
        byte[] array = new byte[bytes.size()];
        for (int i = 0; i < array.length; ++i) {
            array[i] = bytes.get(i);
        }
        return array;
    }

    public static ImmutableList<Byte> toByteList(byte[] original) {
        return OpenSSL.toByteList(original, 0, original.length);
    }

    public static ImmutableList<Byte> toByteList(byte[] original, int offset, int length) {
        ArrayList list = Lists.newArrayList();
        for (int i = offset; i < length; ++i) {
            list.add(original[i]);
        }
        return ImmutableList.copyOf((Collection)list);
    }

    public static String checkBase64(String text) {
        Precondition.checkNotNull(text, "text");
        for (char c : text.toCharArray()) {
            Preconditions.checkArgument((boolean)OpenSSL.isBase64(c), (String)"'%s' is not a base 64 character", (Object[])new Object[]{Character.valueOf(c)});
        }
        return text;
    }

    public static boolean isBase64(char c) {
        if (Ascii.isLetter(c) || Ascii.isDigit(c)) {
            return true;
        }
        return c == '/' || c == '+' || c == '=';
    }

    public static MessageDigest getMessageDigest(String algorithm) {
        try {
            return MessageDigest.getInstance(algorithm);
        }
        catch (NoSuchAlgorithmException e) {
            throw Exceptions.illegalArgument(e);
        }
    }

    public static OpenSSLEncryptedContext buildEncryptedContext(OpenSSLContext context, int initVectorLength, byte[] salt, byte[] data) {
        MessageDigest md = OpenSSL.getMessageDigest(context.getDigestAlgorithm());
        int keyLength = context.getKeySizeBits() / 8;
        byte[] key = new byte[keyLength];
        int keyIndex = 0;
        byte[] initVector = new byte[initVectorLength];
        int initVectorIndex = 0;
        byte[] md_buf = null;
        int nkey = keyLength;
        int niv = initVectorLength;
        int i = 0;
        int addmd = 0;
        do {
            md.reset();
            if (addmd++ > 0) {
                md.update(md_buf);
            }
            md.update(data);
            if (null != salt) {
                md.update(salt, 0, 8);
            }
            md_buf = md.digest();
            for (i = 1; i < context.getIterations(); ++i) {
                md.reset();
                md.update(md_buf);
                md_buf = md.digest();
            }
            if (nkey > 0) {
                for (i = 0; nkey != 0 && i != md_buf.length; --nkey, ++i) {
                    key[keyIndex++] = md_buf[i];
                }
            }
            if (niv <= 0 || i == md_buf.length) continue;
            while (niv != 0 && i != md_buf.length) {
                initVector[initVectorIndex++] = md_buf[i];
                --niv;
                ++i;
            }
        } while (nkey != 0 || niv != 0);
        for (i = 0; i < md_buf.length; ++i) {
            md_buf[i] = 0;
        }
        OpenSSLEncryptedContext.Builder builder = OpenSSLEncryptedContext.builder();
        builder.withSalt((List<Byte>)OpenSSL.toByteList(salt));
        builder.withKey((List<Byte>)OpenSSL.toByteList(key));
        builder.withInitVector((List<Byte>)OpenSSL.toByteList(initVector));
        return builder.build();
    }

    protected static List<Character> getAlphaNumericCharacters() {
        char c;
        ArrayList chars = Lists.newArrayList();
        for (c = 'A'; c < 'Z'; c = (char)(c + 1)) {
            chars.add(Character.valueOf(c));
        }
        for (c = 'a'; c < 'z'; c = (char)(c + '\u0001')) {
            chars.add(Character.valueOf(c));
        }
        for (c = '0'; c < '9'; c = (char)(c + '\u0001')) {
            chars.add(Character.valueOf(c));
        }
        return ImmutableList.copyOf((Collection)chars);
    }
}

