/*
 * Decompiled with CFR 0.152.
 */
package org.kuali.common.util.encrypt.jasypt;

import org.jasypt.util.text.TextEncryptor;
import org.kuali.common.util.encrypt.EncryptionContext;
import org.kuali.common.util.encrypt.EncryptionStrength;
import org.kuali.common.util.encrypt.Encryptor;
import org.kuali.common.util.encrypt.jasypt.Jasypt;

public final class DefaultJasyptEncryptor
implements Encryptor {
    private final TextEncryptor encryptor;

    public DefaultJasyptEncryptor(String password) {
        this(password, EncryptionStrength.DEFAULT_ENCRYPTION_STRENGTH);
    }

    public DefaultJasyptEncryptor(String password, EncryptionStrength strength) {
        this(new EncryptionContext(password, strength));
    }

    public DefaultJasyptEncryptor(EncryptionContext context) {
        this.encryptor = Jasypt.buildTextEncryptor(context.getPassword(), context.getStrength());
    }

    @Override
    public String encrypt(String text) {
        return this.encryptor.encrypt(text);
    }

    @Override
    public String decrypt(String text) {
        return this.encryptor.decrypt(text);
    }
}

