/*
 * Decompiled with CFR 0.152.
 */
package org.kuali.common.util.encrypt;

import com.google.common.base.Optional;
import org.kuali.common.util.encrypt.EncryptionContext;
import org.kuali.common.util.encrypt.Encryptor;
import org.kuali.common.util.encrypt.NoOpEncryptor;
import org.kuali.common.util.encrypt.openssl.OpenSSL;
import org.kuali.common.util.encrypt.provider.DefaultEncryptionContextProviderChain;
import org.kuali.common.util.log.Loggers;
import org.slf4j.Logger;

public final class Encryption {
    private static final Logger logger = Loggers.newLogger();
    private static Encryptor encryptor;

    public static Encryptor buildEncryptor() {
        DefaultEncryptionContextProviderChain provider = new DefaultEncryptionContextProviderChain();
        Optional<EncryptionContext> context = provider.getEncryptionContext();
        if (context.isPresent()) {
            return OpenSSL.buildOpenSSLEncryptor((EncryptionContext)context.get());
        }
        logger.info(String.format("encryption disabled. no encryption password was located", new Object[0]));
        return NoOpEncryptor.INSTANCE;
    }

    public static synchronized Encryptor getDefaultEncryptor() {
        if (encryptor == null) {
            encryptor = Encryption.buildEncryptor();
        }
        return encryptor;
    }
}

