/*
 * Decompiled with CFR 0.152.
 */
package org.kuali.common.util.base;

import java.io.IOException;
import java.io.PrintWriter;
import java.io.StringWriter;

public final class Exceptions {
    public static String printStackTraceToString(Throwable throwable) {
        StringWriter sw = new StringWriter();
        throwable.printStackTrace(new PrintWriter(sw));
        return sw.toString();
    }

    public static IOException newIOException(Throwable cause) {
        return new IOException(cause);
    }

    public static IOException newIOException(String msg) {
        return new IOException(msg);
    }

    public static IOException newIOException(String msg, Object ... args) {
        return new IOException(Exceptions.formatted(msg, args));
    }

    public static IOException newIOException(Throwable cause, String msg, Object ... args) {
        return new IOException(Exceptions.formatted(msg, args), cause);
    }

    public static IllegalStateException illegalState(Throwable cause) {
        return new IllegalStateException(cause);
    }

    public static IllegalStateException illegalState(String msg) {
        return new IllegalStateException(msg);
    }

    public static IllegalStateException illegalState(String msg, Object ... args) {
        return new IllegalStateException(Exceptions.formatted(msg, args));
    }

    public static IllegalStateException illegalState(Throwable cause, String msg, Object ... args) {
        return new IllegalStateException(Exceptions.formatted(msg, args), cause);
    }

    public static IllegalArgumentException illegalArgument(Throwable cause) {
        return new IllegalArgumentException(cause);
    }

    public static IllegalArgumentException illegalArgument(String msg) {
        return new IllegalArgumentException(msg);
    }

    public static IllegalArgumentException illegalArgument(String msg, Object ... args) {
        return new IllegalArgumentException(Exceptions.formatted(msg, args));
    }

    public static IllegalArgumentException illegalArgument(Throwable cause, String msg, Object ... args) {
        return new IllegalArgumentException(Exceptions.formatted(msg, args), cause);
    }

    private static String formatted(String msg, Object ... args) {
        return args == null || args.length == 0 ? msg : String.format(msg, args);
    }
}

