/*
 * Decompiled with CFR 0.152.
 */
package org.kuali.common.util;

import java.io.UnsupportedEncodingException;
import java.util.List;
import org.apache.commons.lang3.StringUtils;
import org.kuali.common.util.Ascii;
import org.kuali.common.util.Assert;

public class Str {
    public static final String EMPTY_STRING = "";
    public static final String UTF8 = "UTF-8";
    public static final String COMMA = ",";
    public static final String SPACE = " ";
    public static final String CR = "\r";
    public static final String LF = "\n";
    public static final String DOT = ".";
    public static final String COLON = ":";
    public static final String FORWARD_SLASH = "/";
    public static final char DOUBLE_QUOTE = '\"';
    public static final String CDATA_PREFIX = "<![CDATA[";
    public static final String CDATA_SUFFIX = "]]>";
    public static final String[] EMPTY_ARRAY = new String[0];
    private static final String CONCEALED_PREFIX = "cnc--";

    public static final String conceal(String text) {
        if (text == null) {
            return null;
        }
        Assert.noBlanks(text);
        if (Str.isConcealed(text)) {
            return text;
        }
        Assert.notConcealed(text);
        char[] chars = text.toCharArray();
        StringBuilder sb = new StringBuilder();
        sb.append(CONCEALED_PREFIX);
        for (char c : chars) {
            sb.append(Ascii.flip(c));
        }
        return sb.toString();
    }

    public static final String reveal(String text) {
        if (text == null) {
            return null;
        }
        Assert.noBlanks(text);
        if (!Str.isConcealed(text)) {
            return text;
        }
        Assert.concealed(text);
        String substring = Str.removePrefix(text, CONCEALED_PREFIX);
        char[] chars = substring.toCharArray();
        StringBuilder sb = new StringBuilder();
        for (char c : chars) {
            sb.append(Ascii.flip(c));
        }
        return sb.toString();
    }

    public static final boolean isConcealed(String text) {
        return StringUtils.startsWith((CharSequence)text, (CharSequence)CONCEALED_PREFIX);
    }

    public static final String[] toEmptyArray(String[] strings) {
        if (strings == null) {
            return EMPTY_ARRAY;
        }
        return strings;
    }

    public static final String getId(String ... tokens) {
        if (tokens == null) {
            return null;
        }
        StringBuilder sb = new StringBuilder();
        for (int i = 0; i < tokens.length; ++i) {
            if (i != 0) {
                sb.append(COLON);
            }
            sb.append(StringUtils.trimToEmpty((String)tokens[i]));
        }
        return sb.toString();
    }

    public static final String cdata(String s) {
        if (s == null) {
            return null;
        }
        return CDATA_PREFIX + s + CDATA_SUFFIX;
    }

    public static final String removeSuffix(String s, String suffix) {
        if (StringUtils.endsWith((CharSequence)s, (CharSequence)suffix)) {
            int end = StringUtils.length((CharSequence)s) - StringUtils.length((CharSequence)suffix);
            return StringUtils.substring((String)s, (int)0, (int)end);
        }
        return s;
    }

    public static final String removePrefix(String s, String prefix) {
        if (StringUtils.startsWith((CharSequence)s, (CharSequence)prefix)) {
            int beginIndex = StringUtils.length((CharSequence)prefix);
            return StringUtils.substring((String)s, (int)beginIndex);
        }
        return s;
    }

    public static final boolean matches(String s, String prefix, String suffix) {
        return StringUtils.startsWith((CharSequence)s, (CharSequence)prefix) && StringUtils.endsWith((CharSequence)s, (CharSequence)suffix);
    }

    public static final String remove(String s, String prefix, String suffix) {
        String returnValue = s;
        returnValue = Str.removePrefix(returnValue, prefix);
        returnValue = Str.removeSuffix(returnValue, suffix);
        return returnValue;
    }

    public static final String toEmpty(String s) {
        if (s == null) {
            return EMPTY_STRING;
        }
        return s;
    }

    public static final String getAsciiString(byte[] bytes) {
        return Str.getString(bytes, "US-ASCII");
    }

    public static final String getUTF8String(byte[] bytes) {
        return Str.getString(bytes, UTF8);
    }

    public static final String getString(byte[] bytes, String encoding) {
        if (bytes == null) {
            return null;
        }
        if (encoding == null) {
            return new String(bytes);
        }
        try {
            return new String(bytes, encoding);
        }
        catch (UnsupportedEncodingException e) {
            throw new IllegalArgumentException(e);
        }
    }

    public static final byte[] getAsciiBytes(String s) {
        if (s == null) {
            return null;
        }
        return Str.getBytes(s, "US-ASCII");
    }

    public static final byte[] getUTF8Bytes(String s) {
        if (s == null) {
            return null;
        }
        return Str.getBytes(s, UTF8);
    }

    public static final byte[] getBytes(String s, String encoding) {
        if (s == null) {
            return null;
        }
        if (encoding == null) {
            return s.getBytes();
        }
        try {
            return s.getBytes(encoding);
        }
        catch (UnsupportedEncodingException e) {
            throw new IllegalArgumentException(e);
        }
    }

    public static final boolean contains(List<String> tokens, String value, boolean caseSensitive) {
        for (String token : tokens) {
            if (!Str.equals(token, value, caseSensitive)) continue;
            return true;
        }
        return false;
    }

    public static final boolean equals(String s1, String s2, boolean caseSensitive) {
        if (caseSensitive) {
            return StringUtils.equals((CharSequence)s1, (CharSequence)s2);
        }
        return StringUtils.equalsIgnoreCase((CharSequence)s1, (CharSequence)s2);
    }

    public static final String toString(String[] tokens) {
        if (tokens == null) {
            return null;
        }
        StringBuilder sb = new StringBuilder();
        for (String token : tokens) {
            sb.append(token);
        }
        return sb.toString();
    }

    public static final String getPath(String s) {
        return StringUtils.trim((String)StringUtils.replace((String)s, (String)DOT, (String)FORWARD_SLASH));
    }

    public static final String quote(String s) {
        return s == null ? null : '\"' + s + '\"';
    }

    public static final String[] splitCSV(String csv, boolean trim) {
        return Str.split(csv, COMMA, trim);
    }

    public static final String[] splitAndTrimCSV(String csv) {
        return Str.splitCSV(csv, true);
    }

    public static final String[] splitAndTrim(String s, String separatorChars) {
        return Str.split(s, separatorChars, true);
    }

    public static final String[] split(String s, String separatorChars, boolean trim) {
        String[] tokens = StringUtils.split((String)s, (String)separatorChars);
        if (tokens == null) {
            return null;
        }
        for (int i = 0; i < tokens.length; ++i) {
            tokens[i] = trim ? StringUtils.trim((String)tokens[i]) : tokens[i];
        }
        return tokens;
    }

    public static final String flatten(String s) {
        return Str.flatten(s, SPACE, SPACE);
    }

    public static final String flatten(String s, String cr, String lf) {
        return StringUtils.replace((String)StringUtils.replace((String)s, (String)CR, (String)cr), (String)LF, (String)lf);
    }

    public static final String inflate(String s, String cr, String lf) {
        return StringUtils.replace((String)StringUtils.replace((String)s, (String)cr, (String)CR), (String)lf, (String)LF);
    }
}

