/*
 * Decompiled with CFR 0.152.
 */
package org.kuali.common.util;

import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Properties;
import org.apache.commons.io.FileUtils;
import org.apache.commons.lang3.StringUtils;
import org.kuali.common.util.Assert;
import org.kuali.common.util.CollectionUtils;
import org.kuali.common.util.LocationUtils;
import org.kuali.common.util.MetaInfResource;
import org.kuali.common.util.PropertyUtils;
import org.kuali.common.util.SimpleScanner;
import org.kuali.common.util.metainf.MetaInfContext;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Deprecated
public class MetaInfUtils {
    private static final Logger logger = LoggerFactory.getLogger(MetaInfUtils.class);

    public static void scanAndCreateFiles(List<MetaInfContext> contexts) throws IOException {
        for (MetaInfContext context : contexts) {
            List<File> files = MetaInfUtils.getFiles(context);
            List<MetaInfResource> resources = MetaInfUtils.getResources(context, files);
            MetaInfUtils.doLocations(context, resources);
            if (!context.isAddPropertiesFile()) continue;
            MetaInfUtils.doProperties(context, resources);
        }
    }

    public static List<File> getFiles(MetaInfContext context) throws IOException {
        Assert.notNull((Object)context.getBaseDir(), (String)"baseDir is null");
        Assert.notNull((Object)context.getOutputFile(), (String)"outputFile is null");
        logger.debug("Examining " + LocationUtils.getCanonicalPath(context.getBaseDir()));
        logger.debug("Patterns - {}", (Object)MetaInfUtils.getPatternLogMessage(context));
        List<String> includes = context.getIncludes();
        List<String> excludes = context.getExcludes();
        SimpleScanner scanner = new SimpleScanner(context.getBaseDir(), includes, excludes);
        return scanner.getFiles();
    }

    protected static String getPatternLogMessage(MetaInfContext context) {
        boolean includeEverything;
        StringBuilder sb = new StringBuilder();
        String incl = CollectionUtils.getSpaceSeparatedString(context.getIncludes());
        String excl = CollectionUtils.getSpaceSeparatedString(context.getExcludes());
        sb.append("[");
        if (!StringUtils.isBlank((CharSequence)incl)) {
            sb.append("include: ").append(incl);
        }
        if (!StringUtils.isBlank((CharSequence)excl)) {
            sb.append(", exclude:").append(excl);
        }
        boolean bl = includeEverything = StringUtils.isBlank((CharSequence)incl) && StringUtils.isBlank((CharSequence)excl);
        if (includeEverything) {
            sb.append("include: *");
        }
        sb.append("]");
        return sb.toString();
    }

    public static void doLocations(MetaInfContext context, List<MetaInfResource> resources) throws IOException {
        List<String> locations = MetaInfUtils.getLocations(resources);
        if (context.isSort()) {
            Collections.sort(locations);
        }
        String path1 = LocationUtils.getCanonicalPath(context.getBaseDir());
        String path2 = LocationUtils.getCanonicalPath(context.getOutputFile());
        String path = StringUtils.remove((String)path2, (String)path1);
        logger.info("Creating [" + path + "] - {} resources", (Object)locations.size());
        FileUtils.writeLines((File)context.getOutputFile(), locations);
    }

    public static void doProperties(MetaInfContext context, List<MetaInfResource> resources) {
        logger.debug("doProperties()");
        Properties properties = MetaInfUtils.getProperties(context, resources);
        File propertiesFile = new File(LocationUtils.getCanonicalPath(context.getOutputFile()) + ".properties");
        PropertyUtils.store(properties, propertiesFile, "UTF-8");
    }

    public static Properties getProperties(MetaInfContext context, List<MetaInfResource> resources) {
        Properties properties = new Properties();
        for (MetaInfResource resource : resources) {
            String sizeKey = resource.getKey() + ".size";
            properties.setProperty(sizeKey, resource.getSize() + "");
            if (!context.isAddLineCount()) continue;
            String linesKey = resource.getKey() + ".lines";
            properties.setProperty(linesKey, resource.getLines() + "");
        }
        return properties;
    }

    public static String getPropertyKey(String location) {
        String key = StringUtils.replace((String)location, (String)":", (String)".");
        return StringUtils.replace((String)key, (String)"/", (String)".");
    }

    public static void scanAndCreateFile(MetaInfContext context) throws IOException {
        MetaInfUtils.scanAndCreateFiles(Arrays.asList(context));
    }

    public static List<MetaInfResource> getResources(MetaInfContext context, List<File> files) throws IOException {
        ArrayList<MetaInfResource> resources = new ArrayList<MetaInfResource>();
        for (File file : files) {
            MetaInfResource resource = MetaInfUtils.getResource(context, file);
            resources.add(resource);
        }
        return resources;
    }

    public static List<String> getLocations(List<MetaInfResource> resources) {
        ArrayList<String> locations = new ArrayList<String>();
        for (MetaInfResource resource : resources) {
            locations.add(resource.getLocation());
        }
        return locations;
    }

    public static List<String> getLocations(File baseDir, List<File> files, String prefix) throws IOException {
        ArrayList<String> locations = new ArrayList<String>();
        for (File file : files) {
            String location = MetaInfUtils.getLocation(baseDir, file, prefix);
            locations.add(location);
        }
        return locations;
    }

    public static MetaInfResource getResource(MetaInfContext context, File file) throws IOException {
        String location = MetaInfUtils.getLocation(context.getBaseDir(), file, context.getPrefix());
        long size = file.length();
        long lines = -1L;
        if (context.isAddLineCount()) {
            lines = LocationUtils.getLineCount(file);
        }
        String key = MetaInfUtils.getPropertyKey(location);
        MetaInfResource resource = new MetaInfResource();
        resource.setLocation(location);
        resource.setSize(size);
        resource.setKey(key);
        resource.setLines(lines);
        return resource;
    }

    public static String getLocation(File baseDir, File file, String prefix) throws IOException {
        String dir = baseDir.getCanonicalPath();
        String path = file.getCanonicalPath();
        int pos = dir.length() + 1;
        return prefix + StringUtils.substring((String)path, (int)pos);
    }
}

