/*
 * Decompiled with CFR 0.152.
 */
package org.kuali.common.util;

import org.kuali.common.util.Assert;

public class LongCounter {
    long count;

    public LongCounter() {
        this(0L);
    }

    public LongCounter(long startValue) {
        this.count = startValue;
    }

    public synchronized long increment() {
        return this.increment(1L);
    }

    public synchronized long increment(long amount) {
        Assert.isTrue((amount > 0L ? 1 : 0) != 0, (String)"amount must be > 0");
        Assert.isTrue((this.count <= Long.MAX_VALUE - amount ? 1 : 0) != 0, (String)"max value exceeded");
        return this.count += amount;
    }

    public synchronized long decrement(long amount) {
        Assert.isTrue((amount > 0L ? 1 : 0) != 0, (String)"amount must be > 0");
        Assert.isTrue((this.count >= Long.MIN_VALUE + amount ? 1 : 0) != 0, (String)"min value exceeded");
        return this.count -= amount;
    }

    public synchronized long decrement() {
        return this.decrement(1L);
    }

    public synchronized long getValue() {
        return this.count;
    }
}

