/*
 * Decompiled with CFR 0.152.
 */
package org.kuali.common.util;

import java.io.UnsupportedEncodingException;
import org.apache.commons.lang3.CharSet;
import org.apache.commons.lang3.StringUtils;
import org.kuali.common.util.base.Exceptions;

public class HexUtils {
    private static final String ZERO = "0";
    private static final int BYTE_MASK = 255;
    private static final String[] HEX_RANGES = new String[]{"0-9", "A-F", "a-f"};
    private static final String HEX_RANGES_STRING = HexUtils.toString(HEX_RANGES);
    private static final CharSet HEX_CHARSET = CharSet.getInstance((String[])HEX_RANGES);

    public static final CharSet getHexCharSet() {
        return HEX_CHARSET;
    }

    public static final String[] getHexRanges() {
        return HEX_RANGES;
    }

    protected static final String toString(String[] tokens) {
        StringBuilder sb = new StringBuilder();
        sb.append("[");
        for (int i = 0; i < HEX_RANGES.length; ++i) {
            if (i != 0) {
                sb.append(",");
            }
            sb.append(HEX_RANGES[i]);
        }
        sb.append("]");
        return sb.toString();
    }

    public static String toHexString(String string, String encoding) throws UnsupportedEncodingException {
        byte[] bytes = encoding == null ? string.getBytes() : string.getBytes(encoding);
        return HexUtils.toHexString(bytes);
    }

    public static String toHexString(byte[] bytes) {
        StringBuilder sb = new StringBuilder();
        for (byte b : bytes) {
            int masked = 0xFF & b;
            String hex = Integer.toHexString(masked).toUpperCase();
            String padded = StringUtils.leftPad((String)hex, (int)2, (String)ZERO);
            sb.append(padded);
        }
        return sb.toString();
    }

    public static String toHexStringLower(byte[] bytes) {
        return HexUtils.toHexString(bytes).toLowerCase();
    }

    public static final boolean isHex(char ... chars) {
        for (char c : chars) {
            if (HEX_CHARSET.contains(c)) continue;
            return false;
        }
        return true;
    }

    public static final byte[] getBytesFromHexString(String hex) {
        char[] chars = hex.toCharArray();
        int length = chars.length;
        if (length % 2 != 0) {
            throw Exceptions.illegalArgument("Invalid hex string [%s].  String must contain an even number of characters.  %s is not an even number!", hex, length);
        }
        byte[] bytes = new byte[length / 2];
        int byteIndex = 0;
        for (int i = 0; i < length; i += 2) {
            char c1 = chars[i];
            char c2 = chars[i + 1];
            String s = c1 + "" + c2;
            if (!HexUtils.isHex(c1, c2)) {
                int byteNumber = i / 2 + 1;
                throw Exceptions.illegalArgument("Invalid hex string [%s].  Invalid hex detected at byte %s [%s].  Both characters must be in the range %s", hex, byteNumber, s, HEX_RANGES_STRING);
            }
            int integer = Integer.parseInt(s, 16);
            int masked = integer & 0xFF;
            byte b = (byte)masked;
            bytes[byteIndex++] = b;
        }
        return bytes;
    }

    public static final String toStringFromHex(String hex, String encoding) throws UnsupportedEncodingException {
        byte[] bytes = HexUtils.getBytesFromHexString(hex);
        return StringUtils.toString((byte[])bytes, (String)encoding);
    }
}

