/*
 * Decompiled with CFR 0.152.
 */
package org.kuali.common.util;

import org.kuali.common.util.Assert;

public class Counter {
    int count;

    public Counter() {
        this(0);
    }

    public Counter(int startValue) {
        this.count = startValue;
    }

    public synchronized int increment() {
        return this.increment(1);
    }

    public synchronized int increment(int amount) {
        Assert.isTrue((amount > 0 ? 1 : 0) != 0, (String)"amount must be > 0");
        Assert.isTrue((this.count <= Integer.MAX_VALUE - amount ? 1 : 0) != 0, (String)"max value exceeded");
        return this.count += amount;
    }

    public synchronized int decrement() {
        return this.decrement(1);
    }

    public synchronized int decrement(int amount) {
        Assert.isTrue((amount > 0 ? 1 : 0) != 0, (String)"amount must be > 0");
        Assert.isTrue((this.count >= Integer.MIN_VALUE + amount ? 1 : 0) != 0, (String)"min value exceeded");
        return this.count -= amount;
    }

    public synchronized int getValue() {
        return this.count;
    }
}

