/**
 * Copyright 2010-2014 The Kuali Foundation
 *
 * Licensed under the Educational Community License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 * http://www.opensource.org/licenses/ecl2.php
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
package org.kuali.common.util.xml.jaxb.wrapper;

import java.util.HashMap;
import java.util.Map;

import javax.xml.bind.annotation.XmlAnyElement;

import org.kuali.common.util.Assert;

public class MapWrapper<K, V> {

	@XmlAnyElement(lax = true)
	private final Map<K, V> map;

	@SuppressWarnings("unused")
	private MapWrapper() {
		this(new HashMap<K, V>());
	}

	public MapWrapper(Map<K, V> map) {
		Assert.noNulls(map);
		this.map = map;
	}

	public Map<K, V> getMap() {
		return map;
	}

}
