/**
 * Copyright 2010-2014 The Kuali Foundation
 *
 * Licensed under the Educational Community License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 * http://www.opensource.org/licenses/ecl2.php
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
package org.kuali.common.util.stream;

import static com.google.common.base.Optional.absent;
import static java.util.Collections.synchronizedList;

import java.util.ArrayList;
import java.util.List;

import org.codehaus.plexus.util.cli.StreamConsumer;

import com.google.common.base.Joiner;
import com.google.common.base.Optional;
import com.google.common.collect.ImmutableList;

public final class StringStreamConsumer implements StreamConsumer {

	private static final String LS = System.getProperty("line.separator");
	private final List<String> lines = synchronizedList(new ArrayList<String>());

	@Override
	public void consumeLine(String line) {
		lines.add(line);
	}

	public synchronized Optional<String> getOutput() {
		if (lines.size() > 0) {
			return Optional.of(Joiner.on(LS).join(lines));
		} else {
			return absent();
		}
	}

	public synchronized List<String> getLines() {
		return ImmutableList.copyOf(lines);
	}

}
