/**
 * Copyright 2010-2014 The Kuali Foundation
 *
 * Licensed under the Educational Community License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 * http://www.opensource.org/licenses/ecl2.php
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
package org.kuali.common.util.spring.env;

import java.util.Properties;

import org.kuali.common.util.PropertyUtils;
import org.kuali.common.util.property.ImmutableProperties;
import org.springframework.core.env.AbstractEnvironment;
import org.springframework.core.env.PropertiesPropertySource;

public final class PropertiesEnvironment extends AbstractEnvironment {

	private static final String NAME = "properties";

	/**
	 * Default environment that uses system properties / environment variables (prefixed with <code>env</code>)
	 */
	public PropertiesEnvironment() {
		this(PropertyUtils.getGlobalProperties());
	}

	/**
	 * Create an environment based on <code>properties</code>
	 */
	public PropertiesEnvironment(Properties properties) {
		this(NAME, properties);
	}

	public PropertiesEnvironment(String name, Properties properties) {
		this.properties = ImmutableProperties.copyOf(properties);
		super.getPropertySources().addLast(new PropertiesPropertySource(name, properties));
	}

	private final Properties properties;

	public Properties getProperties() {
		return properties;
	}

}
