/**
 * Copyright 2010-2014 The Kuali Foundation
 *
 * Licensed under the Educational Community License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 * http://www.opensource.org/licenses/ecl2.php
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
package org.kuali.common.util.runonce;

import java.io.File;
import java.util.Properties;

import org.apache.commons.lang3.StringUtils;
import org.kuali.common.util.Assert;
import org.kuali.common.util.PropertyUtils;
import org.kuali.common.util.file.CanonicalFile;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

/**
 * This implementation has issues. Don't use it.
 * 
 * @deprecated Use org.kuali.common.util.runonce.smart.PropertiesFileStateManager instead
 */
@Deprecated
public class PropertiesFileStateManager implements RunOnceStateManager {

	private static final Logger logger = LoggerFactory.getLogger(PropertiesFileStateManager.class);

	public PropertiesFileStateManager(File propertiesFile, String encoding, String persistentPropertyKey) {
		Assert.noNulls(propertiesFile);
		Assert.noBlanks(persistentPropertyKey, encoding);
		this.propertiesFile = new CanonicalFile(propertiesFile);
		this.encoding = encoding;
		this.persistentPropertyKey = persistentPropertyKey;
	}

	private final String persistentPropertyKey;
	private final File propertiesFile;
	private final String encoding;

	private Properties properties;
	private boolean runonce;
	private boolean initialized;

	@Override
	public synchronized void initialize() {
		Assert.isFalse(initialized, "Already initialized");
		this.properties = getProperties();
		this.runonce = getRunOnce();
		this.initialized = true;
	}

	@Override
	public synchronized boolean isRunOnce() {
		Assert.isTrue(initialized, "Not initialized");
		return runonce;
	}

	@Override
	public synchronized void persistState(RunOnceState state) {
		Assert.isTrue(initialized, "Not initialized");
		Assert.noNulls(state);
		properties.setProperty(persistentPropertyKey, state.name());
		PropertyUtils.store(properties, propertiesFile, encoding);
	}

	public String getPersistentPropertyKey() {
		return persistentPropertyKey;
	}

	public File getPropertiesFile() {
		return propertiesFile;
	}

	protected Properties getProperties() {
		if (propertiesFile.exists()) {
			return PropertyUtils.load(propertiesFile, encoding);
		} else {
			logger.info("Skipping execution. File does not exist - [{}]", propertiesFile);
			return PropertyUtils.EMPTY;
		}
	}

	protected boolean getRunOnce() {
		if (properties == PropertyUtils.EMPTY) {
			return false;
		} else {
			// Log a message indicating we found the properties file and are going to inspect its contents
			logger.info("Examining run once property [{}] in [{}]", persistentPropertyKey, propertiesFile);
			String value = properties.getProperty(persistentPropertyKey);
			boolean runonce = StringUtils.equalsIgnoreCase(Boolean.TRUE.toString(), value);
			if (!runonce) {
				logger.info("Skipping execution - [{}={}]", persistentPropertyKey, value);
			}
			return runonce;
		}
	}

}
