/**
 * Copyright 2010-2014 The Kuali Foundation
 *
 * Licensed under the Educational Community License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 * http://www.opensource.org/licenses/ecl2.php
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
package org.kuali.common.util.properties;

import java.util.Properties;

import org.kuali.common.util.Assert;
import org.kuali.common.util.cache.Cache;
import org.kuali.common.util.property.ImmutableProperties;

public final class CachingLoader implements PropertiesLoader {

	private final Cache<String, Properties> cache;
	private final LocationLoader loader;

	public CachingLoader(Location location, Cache<String, Properties> cache) {
		this(location, location.getValue(), cache);
	}

	public CachingLoader(Location location, String value, Cache<String, Properties> cache) {
		Assert.noNulls(cache);
		this.cache = cache;
		this.loader = new LocationLoader(location, value);
	}

	@Override
	public Properties load() {

		if (!loader.getLocation().isCacheable()) {
			return loader.load();
		}

		Properties properties = cache.get(loader.getValue());
		if (properties == null) {
			properties = new ImmutableProperties(loader.load());
			this.cache.put(loader.getValue(), properties);
		}
		return properties;

	}

}
