/**
 * Copyright 2010-2014 The Kuali Foundation
 *
 * Licensed under the Educational Community License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 * http://www.opensource.org/licenses/ecl2.php
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
package org.kuali.common.util.project.model;

import java.io.File;

import org.kuali.common.util.Assert;

public final class Build {

	public Build(Project project, String encoding, File projectDir, File directory, File outputDir, File sourceDir, File scriptSourceDir, File testOutputDir, File testSourceDir) {
		Assert.noNulls(project, encoding, projectDir, directory, outputDir, sourceDir, scriptSourceDir, testOutputDir, testSourceDir);
		this.project = project;
		this.encoding = encoding;
		this.projectDir = projectDir;
		this.directory = directory;
		this.outputDir = outputDir;
		this.sourceDir = sourceDir;
		this.scriptSourceDir = scriptSourceDir;
		this.testOutputDir = testOutputDir;
		this.testSourceDir = testSourceDir;
	}

	private final Project project;
	private final String encoding;
	private final File projectDir;
	private final File directory;
	private final File outputDir;
	private final File sourceDir;
	private final File scriptSourceDir;
	private final File testOutputDir;
	private final File testSourceDir;

	public File getProjectDir() {
		return projectDir;
	}

	public File getDirectory() {
		return directory;
	}

	public File getOutputDir() {
		return outputDir;
	}

	public File getSourceDir() {
		return sourceDir;
	}

	public File getScriptSourceDir() {
		return scriptSourceDir;
	}

	public File getTestOutputDir() {
		return testOutputDir;
	}

	public File getTestSourceDir() {
		return testSourceDir;
	}

	public Project getProject() {
		return project;
	}

	public String getEncoding() {
		return encoding;
	}

}
