/**
 * Copyright 2010-2014 The Kuali Foundation
 *
 * Licensed under the Educational Community License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 * http://www.opensource.org/licenses/ecl2.php
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
package org.kuali.common.util.primitives;

public final class Numbers {

	private Numbers() {
	}

	public static boolean between(int number, int min, int max) {
		return number >= min && number <= max;
	}

	/**
	 * Return the smallest Number it is safe to return. Returns a Byte, Short, Integer, or Long.
	 */
	public static Number narrow(long number) {
		if (isByte(number)) {
			return (byte) number;
		} else if (isShort(number)) {
			return (short) number;
		} else if (isInt(number)) {
			return (int) number;
		} else {
			return number;
		}
	}

	public static boolean isByte(long number) {
		return number >= Byte.MIN_VALUE && number <= Byte.MAX_VALUE;
	}

	public static boolean isShort(long number) {
		return number >= Short.MIN_VALUE && number <= Short.MAX_VALUE;
	}

	public static boolean isInt(long number) {
		return number >= Integer.MIN_VALUE && number <= Integer.MAX_VALUE;
	}

}
