/**
 * Copyright 2010-2014 The Kuali Foundation
 *
 * Licensed under the Educational Community License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 * http://www.opensource.org/licenses/ecl2.php
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
package org.kuali.common.util.main;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Map;

import org.kuali.common.util.Assert;
import org.kuali.common.util.spring.service.PropertySourceConfig;
import org.kuali.common.util.spring.service.PropertySourceService;
import org.springframework.core.env.PropertySource;

public class DefaultMainService implements MainService {

	private final PropertySourceService service;

	public DefaultMainService(PropertySourceService service) {
		Assert.noNulls(service);
		this.service = service;
	}

	@Override
	public PropertySource<?> getPropertySource(MainContext context, Class<? extends PropertySourceConfig> config) {
		Assert.noNulls(context, config);
		Map<String, Object> beans = Collections.singletonMap(MainUtils.MAIN_CONTEXT_BEAN_NAME, (Object) context);
		List<String> activeProfiles = Arrays.asList(MainUtils.MAIN_PROFILE_NAME);
		return service.getPropertySource(beans, null, activeProfiles, config);
	}

	public PropertySourceService getService() {
		return service;
	}

}
