/**
 * Copyright 2010-2014 The Kuali Foundation
 *
 * Licensed under the Educational Community License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 * http://www.opensource.org/licenses/ecl2.php
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
package org.kuali.common.util.log4j.model;

import java.util.ArrayList;
import java.util.List;

import javax.xml.bind.annotation.XmlAttribute;
import javax.xml.bind.annotation.XmlElement;

/**
 * @deprecated
 */
@Deprecated
public class Appender {

	String name;
	Class<?> javaClass;
	Layout layout;
	List<Param> params = new ArrayList<Param>();

	public Appender(Appender appender) {
		super();
		this.name = appender.getName();
		this.javaClass = appender.getJavaClass();
		this.layout = appender.getLayout();
		for (Param param : params) {
			this.params.add(new Param(param));
		}
	}

	public Appender() {
		this(null, null, null);
	}

	public Appender(String name, Class<?> javaClass, Layout layout) {
		super();
		this.name = name;
		this.javaClass = javaClass;
		this.layout = layout;
	}

	@XmlAttribute
	public String getName() {
		return name;
	}

	@XmlAttribute(name = "class")
	public Class<?> getJavaClass() {
		return javaClass;
	}

	@XmlElement(name = "param")
	public List<Param> getParams() {
		return params;
	}

	public void setName(String name) {
		this.name = name;
	}

	public void setJavaClass(Class<?> javaClass) {
		this.javaClass = javaClass;
	}

	public Layout getLayout() {
		return layout;
	}

	public void setLayout(Layout layout) {
		this.layout = layout;
	}

	public void setParams(List<Param> params) {
		this.params = params;
	}
}
