/**
 * Copyright 2010-2014 The Kuali Foundation
 *
 * Licensed under the Educational Community License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 * http://www.opensource.org/licenses/ecl2.php
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
package org.kuali.common.util.encrypt.provider;

import static com.google.common.base.StandardSystemProperty.USER_HOME;
import static org.apache.commons.io.FileUtils.readFileToString;
import static org.apache.commons.lang3.StringUtils.substringBetween;
import static org.kuali.common.util.base.Exceptions.illegalState;

import java.io.File;
import java.io.IOException;

import org.kuali.common.util.file.CanonicalFile;

public final class MavenEncryptionContextProvider extends AbstractEncryptionContextProvider {

    private static final File USER_SETTINGS = getDefaultSettingsXmlFile();

    public MavenEncryptionContextProvider(String passwordKey, String strengthKey) {
        super(passwordKey, strengthKey);
    }

    @Override
    protected String getValueFromSource(String key) {
        if (!USER_SETTINGS.exists()) {
            return null;
        }
        String content = getContent(USER_SETTINGS);
        String open = "<" + key + ">";
        String close = "</" + key + ">";
        return substringBetween(content, open, close);
    }

    private static String getContent(File file) {
        try {
            return readFileToString(file);
        } catch (IOException e) {
            throw illegalState(e);
        }
    }

    private static File getDefaultSettingsXmlFile() {
        return new CanonicalFile(USER_HOME.value() + "/.m2/settings.xml");
    }

}
