/**
 * Copyright 2010-2014 The Kuali Foundation
 *
 * Licensed under the Educational Community License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 * http://www.opensource.org/licenses/ecl2.php
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
package org.kuali.common.util.condition;

import java.util.List;

import org.kuali.common.util.Assert;

import com.google.common.collect.ImmutableList;

public final class ConditionsCondition implements Condition {

	public ConditionsCondition(List<Condition> conditions) {
		Assert.noNulls(conditions);
		this.conditions = ImmutableList.copyOf(conditions);
	}

	private final List<Condition> conditions;

	@Override
	public boolean isTrue() {
		for (Condition condition : conditions) {
			if (!condition.isTrue()) {
				return false;
			}
		}
		return true;
	}

	public List<Condition> getConditions() {
		return conditions;
	}

}
