/**
 * Copyright 2010-2014 The Kuali Foundation
 *
 * Licensed under the Educational Community License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 * http://www.opensource.org/licenses/ecl2.php
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
package org.kuali.common.util.xml.jaxb.adapter;

import javax.xml.bind.annotation.adapters.XmlAdapter;

import org.kuali.common.util.Assert;

public abstract class OmitClassAdapter extends XmlAdapter<Class<?>, Class<?>> {

	public OmitClassAdapter(Class<?> omitClass) {
		Assert.noNulls(omitClass);
		this.omitClass = omitClass;
	}

	private final Class<?> omitClass;

	@Override
	public final Class<?> marshal(Class<?> value) {
		if (omitClass == value) {
			return null;
		} else {
			return value;
		}
	}

	@Override
	public final Class<?> unmarshal(Class<?> value) {
		if (value == null) {
			return omitClass;
		} else {
			return value;
		}
	}

	public final Class<?> getOmitClass() {
		return omitClass;
	}

}
