/**
 * Copyright 2010-2014 The Kuali Foundation
 *
 * Licensed under the Educational Community License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 * http://www.opensource.org/licenses/ecl2.php
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
package org.kuali.common.util.stream;

import static org.kuali.common.util.base.Precondition.checkNotNull;
import static org.kuali.common.util.log.LoggerLevel.INFO;
import static org.kuali.common.util.log.LoggerUtils.logMsg;

import org.codehaus.plexus.util.cli.StreamConsumer;
import org.kuali.common.util.log.LoggerLevel;
import org.slf4j.Logger;

public final class LoggingStreamConsumer implements StreamConsumer {

	private final Logger logger;
	private final LoggerLevel level;

	public LoggingStreamConsumer(Logger logger) {
		this(logger, INFO);
	}

	public LoggingStreamConsumer(Logger logger, LoggerLevel level) {
		this.logger = checkNotNull(logger, "logger");
		this.level = checkNotNull(level, "level");
	}

	@Override
	public void consumeLine(String line) {
		logMsg(line, logger, level);
	}

	public Logger getLogger() {
		return logger;
	}

	public LoggerLevel getLevel() {
		return level;
	}

}
