/**
 * Copyright 2010-2014 The Kuali Foundation
 *
 * Licensed under the Educational Community License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 * http://www.opensource.org/licenses/ecl2.php
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
package org.kuali.common.util.property.processor;

import java.util.List;
import java.util.Properties;

import org.kuali.common.util.Assert;

import com.google.common.collect.ImmutableList;

public class ProcessorsProcessor implements PropertyProcessor {

	public ProcessorsProcessor(PropertyProcessor... processors) {
		this(ImmutableList.copyOf(processors));
	}

	public ProcessorsProcessor(List<PropertyProcessor> processors) {
		Assert.noNulls(processors);
		this.processors = ImmutableList.copyOf(processors);
	}

	private final List<PropertyProcessor> processors;

	@Override
	public void process(Properties properties) {
		for (PropertyProcessor processor : processors) {
			processor.process(properties);
		}
	}

	public List<PropertyProcessor> getProcessors() {
		return processors;
	}

}
