/**
 * Copyright 2010-2014 The Kuali Foundation
 *
 * Licensed under the Educational Community License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 * http://www.opensource.org/licenses/ecl2.php
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
package org.kuali.common.util.properties.spring;

import org.kuali.common.util.project.ProjectService;
import org.kuali.common.util.project.spring.ProjectServiceConfig;
import org.kuali.common.util.properties.DefaultPropertiesLocationService;
import org.kuali.common.util.properties.PropertiesLocationService;
import org.kuali.common.util.spring.env.EnvironmentService;
import org.kuali.common.util.spring.service.SpringServiceConfig;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.context.annotation.Import;

@Configuration
@Import({ SpringServiceConfig.class, ProjectServiceConfig.class })
public class PropertiesLocationServiceConfig {

	private static final String CACHE_KEY = "properties.cache";
	private static final boolean DEFAULT_CACHE_PROPERTIES_VALUE = true;

	@Autowired
	EnvironmentService env;

	@Autowired
	ProjectService projectService;

	@Bean
	public PropertiesLocationService propertiesLocationService() {
		boolean cache = env.getBoolean(CACHE_KEY, DEFAULT_CACHE_PROPERTIES_VALUE);
		return new DefaultPropertiesLocationService(projectService, cache);
	}

}
