/**
 * Copyright 2010-2014 The Kuali Foundation
 *
 * Licensed under the Educational Community License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 * http://www.opensource.org/licenses/ecl2.php
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
package org.kuali.common.util.properties;

import java.util.List;
import java.util.Properties;

public class SimplePropertiesService implements PropertiesService {

	@Override
	public Properties getProperties(List<Location> locations) {
		Properties properties = new Properties();
		for (Location location : locations) {
			Properties loaded = new LocationLoader(location).load();
			properties.putAll(loaded);
		}
		return properties;
	}

}
