/**
 * Copyright 2010-2014 The Kuali Foundation
 *
 * Licensed under the Educational Community License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 * http://www.opensource.org/licenses/ecl2.php
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
package org.kuali.common.util.metainf.model;

import java.io.File;

import org.kuali.common.util.Assert;

public class WriteRequest {

	private static final File DEFAULT_RELATIVE_DIR = null;

	private final File outputFile;
	private final String encoding;
	private final File relativeDir;

	public WriteRequest(File outputFile, String encoding) {
		this(outputFile, encoding, DEFAULT_RELATIVE_DIR);
	}

	public WriteRequest(File outputFile, String encoding, File relativeDir) {
		Assert.noNulls(outputFile, encoding);
		this.outputFile = outputFile;
		this.encoding = encoding;
		this.relativeDir = relativeDir;
	}

	public File getOutputFile() {
		return outputFile;
	}

	public String getEncoding() {
		return encoding;
	}

	public File getRelativeDir() {
		return relativeDir;
	}

}
