/**
 * Copyright 2010-2014 The Kuali Foundation
 *
 * Licensed under the Educational Community License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 * http://www.opensource.org/licenses/ecl2.php
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
package org.kuali.common.util.maven;

import static org.kuali.common.util.base.Precondition.checkNotNull;
import static org.kuali.common.util.maven.RepositoryUtils.getFilename;
import static org.kuali.common.util.maven.RepositoryUtils.getRepositoryPath;

import org.kuali.common.util.maven.model.Artifact;

import com.google.common.base.Function;
import com.google.common.base.Joiner;

// Singleton enum pattern
public enum RepositoryKeyFunction implements Function<Artifact, String> {
	INSTANCE;

	private static final Joiner JOINER = Joiner.on('/');

	@Override
	public String apply(Artifact artifact) {
		checkNotNull(artifact, "artifact");
		return JOINER.join(getRepositoryPath(artifact), getFilename(artifact));
	}

}
