/**
 * Copyright 2010-2014 The Kuali Foundation
 *
 * Licensed under the Educational Community License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 * http://www.opensource.org/licenses/ecl2.php
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
package org.kuali.common.util.log4j.model;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;

import javax.xml.bind.annotation.XmlAttribute;
import javax.xml.bind.annotation.XmlElement;

import org.kuali.common.util.CollectionUtils;

/**
 * @deprecated
 */
@Deprecated
public class Layout {

	Class<?> javaClass;
	List<Param> params = new ArrayList<Param>();

	public Layout(Layout layout) {
		super();
		this.javaClass = layout.getJavaClass();
		for (Param param : CollectionUtils.toEmptyList(layout.getParams())) {
			this.params.add(new Param(param));
		}
	}

	public Layout() {
		this(null, (List<Param>) null);
	}

	public Layout(Class<?> javaClass, Param param) {
		this(javaClass, Arrays.asList(param));
	}

	public Layout(Class<?> javaClass, List<Param> params) {
		super();
		this.javaClass = javaClass;
		this.params = params;
	}

	@XmlAttribute(name = "class")
	public Class<?> getJavaClass() {
		return javaClass;
	}

	@XmlElement(name = "param")
	public List<Param> getParams() {
		return params;
	}

	public void setJavaClass(Class<?> javaClass) {
		this.javaClass = javaClass;
	}

	public void setParams(List<Param> params) {
		this.params = params;
	}

}
