/**
 * Copyright 2010-2014 The Kuali Foundation
 *
 * Licensed under the Educational Community License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 * http://www.opensource.org/licenses/ecl2.php
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
package org.kuali.common.util.log.log4j.model;

import javax.xml.bind.annotation.XmlAttribute;
import javax.xml.bind.annotation.adapters.XmlJavaTypeAdapter;

import org.kuali.common.util.Assert;
import org.kuali.common.util.log.log4j.jaxb.OmitDefaultLog4JLevelClassAdapter;

public final class Level {

	public static final Class<org.apache.log4j.Level> DEFAULT_CLASS = org.apache.log4j.Level.class;
	public static final Level DEFAULT = new Level();

	@XmlAttribute(name = "class")
	@XmlJavaTypeAdapter(OmitDefaultLog4JLevelClassAdapter.class)
	private final Class<?> levelClass;

	@XmlAttribute
	private final Threshold value;

	private Level() {
		this(DEFAULT_CLASS, Threshold.DEFAULT_LOGGER_VALUE);
	}

	public Level(Threshold value) {
		this(DEFAULT_CLASS, value);
	}

	public Level(Class<?> levelClass, Threshold value) {
		Assert.noNulls(levelClass, value);
		this.levelClass = levelClass;
		this.value = value;
	}

	public Class<?> getLevelClass() {
		return levelClass;
	}

	public Threshold getValue() {
		return value;
	}

}
