/**
 * Copyright 2010-2014 The Kuali Foundation
 *
 * Licensed under the Educational Community License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 * http://www.opensource.org/licenses/ecl2.php
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
package org.kuali.common.util.execute.impl;

import static org.kuali.common.util.base.Precondition.checkNotNull;

import org.kuali.common.util.execute.Executable;

public final class ExecutableRunner implements Runnable {

	public ExecutableRunner(Executable executable) {
		checkNotNull(executable, "executable");
		this.executable = executable;
	}

	private final Executable executable;

	@Override
	public void run() {
		executable.execute();
	}

	public Executable getExecutable() {
		return executable;
	}

}
