/**
 * Copyright 2010-2014 The Kuali Foundation
 *
 * Licensed under the Educational Community License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 * http://www.opensource.org/licenses/ecl2.php
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
package org.kuali.common.util;

import static java.net.URLDecoder.decode;
import static java.net.URLEncoder.encode;
import static org.kuali.common.util.base.Exceptions.illegalState;
import static org.kuali.common.util.base.Precondition.checkNotNull;

import java.io.UnsupportedEncodingException;

public final class Encodings {

	private Encodings() {
	}

	public static final String UTF8 = "UTF-8";
	public static final String ASCII = "US-ASCII";

	public static final String encodeUTF8(String text) {
		try {
			return encode(checkNotNull(text, "text"), UTF8);
		} catch (UnsupportedEncodingException e) {
			throw illegalState(e); // Shouldn't happen. Spec requires JVM's to support UTF-8
		}
	}

	public static final String decodeUTF8(String text) {
		try {
			return decode(checkNotNull(text, "text"), UTF8);
		} catch (UnsupportedEncodingException e) {
			throw illegalState(e); // Shouldn't happen. Spec requires JVM's to support UTF-8
		}
	}

}
