/*
 * Decompiled with CFR 0.152.
 */
package org.kopitubruk.util.json;

import java.util.Enumeration;
import java.util.Map;
import java.util.ResourceBundle;
import org.kopitubruk.util.json.JSONAble;
import org.kopitubruk.util.json.JSONConfig;

class JSONType {
    private boolean isJSONAble;
    private boolean isMapType;
    private boolean isResourceBundle;
    private boolean isArrayType;
    private boolean isReflectType;

    JSONType(Object propertyValue, JSONConfig cfg) {
        this.isJSONAble = propertyValue instanceof JSONAble;
        if (this.isJSONAble) {
            this.isReflectType = false;
            this.isArrayType = false;
            this.isResourceBundle = false;
            this.isMapType = false;
        } else {
            this.isResourceBundle = propertyValue instanceof ResourceBundle;
            boolean bl = this.isMapType = this.isResourceBundle || propertyValue instanceof Map;
            if (this.isMapType) {
                this.isReflectType = false;
                this.isArrayType = false;
            } else {
                Class<?> clazz = null;
                this.isArrayType = propertyValue instanceof Iterable || propertyValue instanceof Enumeration || (clazz = propertyValue.getClass()).isArray();
                this.isReflectType = this.isArrayType ? false : cfg.isReflectClass(clazz);
            }
        }
    }

    boolean isJSONAble() {
        return this.isJSONAble;
    }

    boolean isResourceBundle() {
        return this.isResourceBundle;
    }

    boolean isArrayType() {
        return this.isArrayType;
    }

    boolean isMapType() {
        return this.isMapType;
    }

    boolean isReflectType() {
        return this.isReflectType;
    }

    void forceReflectType() {
        this.isReflectType = !this.isJSONAble && !this.isMapType && !this.isArrayType;
    }

    boolean isRecursible() {
        return this.isJSONAble || this.isMapType || this.isArrayType || this.isReflectType;
    }
}

