/*
 * Decompiled with CFR 0.152.
 */
package org.kopitubruk.util.json;

import java.io.IOException;
import java.io.Writer;
import org.kopitubruk.util.json.JSONConfig;

public class IndentPadding
implements Cloneable {
    private String indent;
    private String newLine;
    private StringBuilder paddingBuf;
    private String padding;
    private int level;

    public IndentPadding() {
        this("    ", "\n");
    }

    public IndentPadding(String indent, String newLine) {
        this.indent = indent;
        this.newLine = newLine;
        this.reset();
    }

    public IndentPadding clone() {
        return new IndentPadding(this.indent, this.newLine);
    }

    public void reset() {
        this.level = 0;
        this.paddingBuf = new StringBuilder();
        this.padding = null;
    }

    public String getIndent() {
        return this.indent;
    }

    public void setIndent(String indent) {
        if (!this.indent.equals(indent)) {
            this.indent = indent;
            this.paddingBuf.setLength(0);
            this.padding = null;
        }
    }

    public void incrementLevel() {
        ++this.level;
    }

    public void decrementLevel() {
        if (this.level > 0) {
            --this.level;
        }
    }

    public String getNewLine() {
        return this.newLine;
    }

    public void setNewLine(String newLine) {
        this.newLine = newLine;
        this.paddingBuf.setLength(0);
        this.padding = null;
    }

    public String getPadding() {
        int needLen = this.level * this.indent.length();
        if (needLen == 0) {
            this.paddingBuf.setLength(0);
            if (this.padding == null) {
                this.padding = this.paddingBuf.toString();
                return this.padding;
            }
            this.padding = null;
        }
        if (this.padding == null || this.padding.length() != (needLen += this.newLine.length())) {
            if (this.paddingBuf.length() == 0) {
                this.paddingBuf.append(this.newLine);
            }
            if (this.paddingBuf.length() > needLen) {
                this.paddingBuf.setLength(needLen);
            }
            while (this.paddingBuf.length() < needLen) {
                this.paddingBuf.append(this.indent);
            }
            this.padding = this.paddingBuf.toString();
        }
        return this.padding;
    }

    static void appendPadding(JSONConfig cfg, Writer json) throws IOException {
        IndentPadding pad = cfg.getIndentPadding();
        if (pad != null) {
            json.write(pad.getPadding());
        }
    }

    static void incPadding(JSONConfig cfg) {
        IndentPadding pad = cfg.getIndentPadding();
        if (pad != null) {
            pad.incrementLevel();
        }
    }

    static void incAppendPadding(JSONConfig cfg, Writer json) throws IOException {
        IndentPadding pad = cfg.getIndentPadding();
        if (pad != null) {
            pad.incrementLevel();
            json.write(pad.getPadding());
        }
    }

    static void incAppendPadding(JSONConfig cfg, Writer json, boolean option) throws IOException {
        if (option) {
            IndentPadding.incAppendPadding(cfg, json);
        }
    }

    static void decAppendPadding(JSONConfig cfg, Writer json, boolean option) throws IOException {
        if (option) {
            IndentPadding.decAppendPadding(cfg, json);
        }
    }

    static void decAppendPadding(JSONConfig cfg, Writer json) throws IOException {
        IndentPadding pad = cfg.getIndentPadding();
        if (pad != null) {
            pad.decrementLevel();
            json.write(pad.getPadding());
        }
    }

    static void decPadding(JSONConfig cfg) throws IOException {
        IndentPadding pad = cfg.getIndentPadding();
        if (pad != null) {
            pad.decrementLevel();
        }
    }

    static void reset(JSONConfig cfg) {
        IndentPadding pad = cfg.getIndentPadding();
        if (pad != null) {
            pad.reset();
        }
    }
}

