/*
 * Decompiled with CFR 0.152.
 */
package org.komamitsu.retrofit.converter.msgpack;

import com.fasterxml.jackson.core.JsonFactory;
import com.fasterxml.jackson.databind.JavaType;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.ObjectReader;
import com.fasterxml.jackson.databind.ObjectWriter;
import java.lang.annotation.Annotation;
import java.lang.reflect.Type;
import okhttp3.RequestBody;
import okhttp3.ResponseBody;
import org.komamitsu.retrofit.converter.msgpack.MessagePackRequestBodyConverter;
import org.komamitsu.retrofit.converter.msgpack.MessagePackResponseBodyConverter;
import org.msgpack.jackson.dataformat.MessagePackFactory;
import retrofit2.Converter;
import retrofit2.Retrofit;

public class MessagePackConverterFactory
extends Converter.Factory {
    private final ObjectMapper mapper;

    public static MessagePackConverterFactory create() {
        return MessagePackConverterFactory.create(new ObjectMapper((JsonFactory)new MessagePackFactory()));
    }

    public static MessagePackConverterFactory create(ObjectMapper mapper) {
        if (mapper == null) {
            throw new IllegalArgumentException("'mapper' is null");
        }
        if (!(mapper.getFactory() instanceof MessagePackFactory)) {
            throw new IllegalArgumentException("'mapper' doesn't have MessagePackFactory");
        }
        return new MessagePackConverterFactory(mapper);
    }

    private MessagePackConverterFactory(ObjectMapper mapper) {
        this.mapper = mapper;
    }

    public Converter<?, RequestBody> requestBodyConverter(Type type, Annotation[] parameterAnnotations, Annotation[] methodAnnotations, Retrofit retrofit) {
        JavaType javaType = this.mapper.getTypeFactory().constructType(type);
        ObjectWriter writer = this.mapper.writerFor(javaType);
        return new MessagePackRequestBodyConverter(writer);
    }

    public Converter<ResponseBody, ?> responseBodyConverter(Type type, Annotation[] annotations, Retrofit retrofit) {
        JavaType javaType = this.mapper.getTypeFactory().constructType(type);
        ObjectReader reader = this.mapper.readerFor(javaType);
        return new MessagePackResponseBodyConverter(reader);
    }
}

