/*
 * Decompiled with CFR 0.152.
 */
package org.komamitsu.fluency.fluentd.ingester.sender.retry;

import org.komamitsu.fluency.fluentd.ingester.sender.retry.RetryStrategy;
import org.komamitsu.fluency.validation.Validatable;
import org.komamitsu.fluency.validation.annotation.Min;

public class ConstantRetryStrategy
extends RetryStrategy {
    private final Config config;

    public ConstantRetryStrategy(Config config) {
        super(config);
        config.validateValues();
        this.config = config;
    }

    @Override
    public int getNextIntervalMillis(int retryCount) {
        return this.config.getRetryIntervalMillis();
    }

    @Override
    public String toString() {
        return "ConstantRetryStrategy{config=" + this.config + "} " + super.toString();
    }

    public static class Config
    extends RetryStrategy.Config
    implements Validatable {
        @Min(value=10L)
        private int retryIntervalMillis = 2000;

        public int getRetryIntervalMillis() {
            return this.retryIntervalMillis;
        }

        public void setRetryIntervalMillis(int retryIntervalMillis) {
            this.retryIntervalMillis = retryIntervalMillis;
        }

        void validateValues() {
            this.validate();
        }

        @Override
        public String toString() {
            return "Config{retryIntervalMillis=" + this.retryIntervalMillis + "} " + super.toString();
        }
    }
}

