/*
 * Decompiled with CFR 0.152.
 */
package org.komamitsu.fluency.fluentd.ingester.sender.heartbeat;

import java.io.Closeable;
import java.io.IOException;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicReference;
import org.komamitsu.fluency.util.ExecutorServiceUtils;
import org.komamitsu.fluency.validation.Validatable;
import org.komamitsu.fluency.validation.annotation.Min;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class Heartbeater
implements Closeable {
    private static final Logger LOG = LoggerFactory.getLogger(Heartbeater.class);
    private final Config config;
    private final ScheduledExecutorService executorService;
    private final AtomicReference<Callback> callback = new AtomicReference();

    protected Heartbeater(Config config) {
        config.validateValues();
        this.config = config;
        this.executorService = ExecutorServiceUtils.newScheduledDaemonThreadPool((int)1);
    }

    public void start() {
        this.executorService.scheduleAtFixedRate(this::ping, this.config.getIntervalMillis(), this.config.getIntervalMillis(), TimeUnit.MILLISECONDS);
    }

    protected abstract void invoke() throws IOException;

    protected void ping() {
        block2: {
            try {
                this.invoke();
            }
            catch (Throwable e) {
                LOG.warn("ping(): failed, config=" + this.config);
                Callback callback = this.callback.get();
                if (callback == null) break block2;
                callback.onFailure(e);
            }
        }
    }

    protected void pong() {
        Callback callback = this.callback.get();
        if (callback != null) {
            callback.onHeartbeat();
        }
    }

    public void setCallback(Callback callback) {
        this.callback.set(callback);
    }

    @Override
    public void close() {
        ExecutorServiceUtils.finishExecutorService((ExecutorService)this.executorService);
    }

    public String getHost() {
        return this.config.getHost();
    }

    public int getPort() {
        return this.config.getPort();
    }

    public int getIntervalMillis() {
        return this.config.getIntervalMillis();
    }

    public String toString() {
        return "Heartbeater{config=" + this.config + '}';
    }

    public static class Config
    implements Validatable {
        private String host = "127.0.0.1";
        private int port = 24224;
        @Min(value=100L)
        private int intervalMillis = 1000;

        public String getHost() {
            return this.host;
        }

        public void setHost(String host) {
            this.host = host;
        }

        public int getPort() {
            return this.port;
        }

        public void setPort(int port) {
            this.port = port;
        }

        public int getIntervalMillis() {
            return this.intervalMillis;
        }

        public void setIntervalMillis(int intervalMillis) {
            this.intervalMillis = intervalMillis;
        }

        void validateValues() {
            this.validate();
        }

        public String toString() {
            return "Config{host='" + this.host + '\'' + ", port=" + this.port + ", intervalMillis=" + this.intervalMillis + '}';
        }
    }

    public static interface Callback {
        public void onHeartbeat();

        public void onFailure(Throwable var1);
    }
}

