/*
 * Decompiled with CFR 0.152.
 */
package org.komamitsu.fluency.fluentd.ingester.sender.failuredetect;

import org.komamitsu.failuredetector.PhiAccuralFailureDetector;
import org.komamitsu.fluency.fluentd.ingester.sender.failuredetect.FailureDetectStrategy;
import org.komamitsu.fluency.validation.Validatable;
import org.komamitsu.fluency.validation.annotation.DecimalMin;
import org.komamitsu.fluency.validation.annotation.Min;

public class PhiAccrualFailureDetectStrategy
extends FailureDetectStrategy {
    private final PhiAccuralFailureDetector failureDetector;
    private final Config config;

    public PhiAccrualFailureDetectStrategy() {
        this(new Config());
    }

    public PhiAccrualFailureDetectStrategy(Config config) {
        super(config);
        config.validateValues();
        this.config = config;
        this.failureDetector = new PhiAccuralFailureDetector.Builder().setThreshold(config.getPhiThreshold()).setMaxSampleSize(config.getArrivalWindowSize()).build();
    }

    @Override
    public void heartbeat(long now) {
        this.failureDetector.heartbeat(now);
    }

    @Override
    public boolean isAvailable() {
        return this.failureDetector.isAvailable();
    }

    public double getPhiThreshold() {
        return this.config.getPhiThreshold();
    }

    public int getArrivalWindowSize() {
        return this.config.getArrivalWindowSize();
    }

    public String toString() {
        return "PhiAccrualFailureDetectStrategy{failureDetector=" + this.failureDetector + "} " + super.toString();
    }

    public static class Config
    extends FailureDetectStrategy.Config
    implements Validatable {
        @DecimalMin(value="0", inclusive=false)
        private double phiThreshold = 16.0;
        @Min(value=0L, inclusive=false)
        private int arrivalWindowSize = 100;

        public double getPhiThreshold() {
            return this.phiThreshold;
        }

        public void setPhiThreshold(float phiThreshold) {
            this.phiThreshold = phiThreshold;
        }

        public int getArrivalWindowSize() {
            return this.arrivalWindowSize;
        }

        void validateValues() {
            this.validate();
        }

        public void setArrivalWindowSize(int arrivalWindowSize) {
            this.arrivalWindowSize = arrivalWindowSize;
        }
    }
}

