/*
 * Decompiled with CFR 0.152.
 */
package org.komamitsu.fluency.fluentd.ingester.sender;

import java.io.Closeable;
import java.io.IOException;
import java.nio.ByteBuffer;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import org.komamitsu.fluency.ingester.sender.ErrorHandler;
import org.komamitsu.fluency.ingester.sender.Sender;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class FluentdSender
implements Closeable,
Sender {
    private static final Logger LOG = LoggerFactory.getLogger(FluentdSender.class);
    private final Config config;

    protected FluentdSender(Config config) {
        this.config = config;
    }

    protected FluentdSender() {
        this(new Config());
    }

    public synchronized void send(ByteBuffer buffer) throws IOException {
        this.sendInternalWithRestoreBufferPositions(Arrays.asList(buffer), null);
    }

    public synchronized void send(List<ByteBuffer> buffers) throws IOException {
        this.sendInternalWithRestoreBufferPositions(buffers, null);
    }

    public void sendWithAck(List<ByteBuffer> buffers, String ackToken) throws IOException {
        this.sendInternalWithRestoreBufferPositions(buffers, ackToken);
    }

    private void sendInternalWithRestoreBufferPositions(List<ByteBuffer> buffers, String ackToken) throws IOException {
        ArrayList<Integer> positions = new ArrayList<Integer>(buffers.size());
        for (ByteBuffer data : buffers) {
            positions.add(data.position());
        }
        try {
            this.sendInternal(buffers, ackToken);
        }
        catch (Exception e) {
            for (int i = 0; i < buffers.size(); ++i) {
                buffers.get(i).position((Integer)positions.get(i));
            }
            ErrorHandler errorHandler = this.config.getErrorHandler();
            if (errorHandler != null) {
                try {
                    errorHandler.handle((Throwable)e);
                }
                catch (Exception ex) {
                    LOG.warn("Failed to handle an error in the error handler {}", (Object)errorHandler, (Object)ex);
                }
            }
            if (e instanceof IOException) {
                throw (IOException)e;
            }
            throw new IOException(e);
        }
    }

    public abstract boolean isAvailable();

    protected abstract void sendInternal(List<ByteBuffer> var1, String var2) throws IOException;

    public static class Config
    extends Sender.Config {
    }
}

