/*
 * Decompiled with CFR 0.152.
 */
package org.kohsuke.junit;

import java.lang.reflect.InvocationHandler;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.lang.reflect.Proxy;
import java.util.LinkedList;
import java.util.List;

public final class ThreadMarshaller
implements InvocationHandler {
    private final Object real;
    private final Object proxy;
    private final List callQueue = new LinkedList();

    public ThreadMarshaller(Class intf, Object realObject) {
        this(new Class[]{intf}, realObject);
    }

    public ThreadMarshaller(Class[] intfs, Object realObject) {
        this.proxy = Proxy.newProxyInstance(intfs[0].getClassLoader(), intfs, (InvocationHandler)this);
        this.real = realObject;
    }

    public Object getProxy() {
        return this.proxy;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Object invoke(Object proxy, Method method, Object[] args) throws Throwable {
        MethodCall mc = new MethodCall(method, args);
        this.callQueue.add(mc);
        MethodCall methodCall = mc;
        synchronized (methodCall) {
            ThreadMarshaller threadMarshaller = this;
            synchronized (threadMarshaller) {
                this.notify();
            }
            mc.wait();
        }
        if (mc.exception != null) {
            throw mc.exception;
        }
        return mc.result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public synchronized void run() {
        while (true) {
            try {
                this.wait();
            }
            catch (InterruptedException e) {
                e.printStackTrace();
            }
            MethodCall mc = (MethodCall)this.callQueue.remove(0);
            if (mc == null) break;
            MethodCall methodCall = mc;
            synchronized (methodCall) {
                mc.execute();
                mc.notify();
            }
        }
    }

    public synchronized void finish() {
        this.callQueue.add(null);
        this.notify();
    }

    class MethodCall {
        Method method;
        Object[] args;
        Throwable exception;
        Object result;

        MethodCall(Method method, Object[] args) {
            this.method = method;
            this.args = args;
        }

        void execute() {
            try {
                this.result = this.method.invoke(ThreadMarshaller.this.real, this.args);
            }
            catch (IllegalAccessException e) {
                throw new IllegalAccessError(e.getMessage());
            }
            catch (InvocationTargetException e) {
                this.exception = e.getTargetException();
            }
            this.method = null;
            this.args = null;
        }
    }
}

