/*
 * Decompiled with CFR 0.152.
 */
package org.kohsuke.github;

import com.infradna.tool.bridge_method_injector.WithBridgeMethods;
import edu.umd.cs.findbugs.annotations.SuppressFBWarnings;
import java.time.Instant;
import java.util.Date;
import org.kohsuke.github.GitHubBridgeAdapterObject;
import org.kohsuke.github.GitHubClient;
import org.kohsuke.github.internal.EnumUtils;

@SuppressFBWarnings(value={"UWF_UNWRITTEN_FIELD"}, justification="JSON API")
public class GHProjectsV2ItemChanges
extends GitHubBridgeAdapterObject {
    private FromToDate archivedAt;
    private FieldValue fieldValue;
    private FromTo previousProjectsV2ItemNodeId;

    public FromToDate getArchivedAt() {
        return this.archivedAt;
    }

    public FieldValue getFieldValue() {
        return this.fieldValue;
    }

    public FromTo getPreviousProjectsV2ItemNodeId() {
        return this.previousProjectsV2ItemNodeId;
    }

    public static class FromToDate {
        private String from;
        private String to;

        @WithBridgeMethods(value={Date.class}, adapterMethod="instantToDate")
        public Instant getFrom() {
            return GitHubClient.parseInstant(this.from);
        }

        @WithBridgeMethods(value={Date.class}, adapterMethod="instantToDate")
        public Instant getTo() {
            return GitHubClient.parseInstant(this.to);
        }
    }

    public static class FieldValue {
        private String fieldNodeId;
        private String fieldType;

        public String getFieldNodeId() {
            return this.fieldNodeId;
        }

        public FieldType getFieldType() {
            return EnumUtils.getEnumOrDefault(FieldType.class, this.fieldType, FieldType.UNKNOWN);
        }
    }

    public static class FromTo {
        private String from;
        private String to;

        public String getFrom() {
            return this.from;
        }

        public String getTo() {
            return this.to;
        }
    }

    public static enum FieldType {
        DATE,
        ITERATION,
        NUMBER,
        SINGLE_SELECT,
        TEXT,
        UNKNOWN;

    }
}

