/*
 * Decompiled with CFR 0.152.
 */
package org.kohsuke.github;

import java.io.IOException;
import java.util.Collections;
import java.util.LinkedHashMap;
import javax.annotation.Nonnull;
import org.kohsuke.github.GHGist;
import org.kohsuke.github.GitHub;
import org.kohsuke.github.Requester;

public class GHGistBuilder {
    private final LinkedHashMap<String, Object> files = new LinkedHashMap();
    private final Requester req;

    public GHGistBuilder(GitHub root) {
        this.req = (Requester)root.createRequest().method("POST");
    }

    public GHGist create() throws IOException {
        this.req.with("files", this.files);
        return ((Requester)this.req.withUrlPath("/gists", new String[0])).fetch(GHGist.class);
    }

    public GHGistBuilder description(String desc) {
        this.req.with("description", desc);
        return this;
    }

    public GHGistBuilder file(@Nonnull String fileName, @Nonnull String content) {
        this.files.put(fileName, Collections.singletonMap("content", content));
        return this;
    }

    public GHGistBuilder public_(boolean v) {
        this.req.with("public", v);
        return this;
    }
}

