/*
 * Decompiled with CFR 0.152.
 */
package org.kohsuke.github;

import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonSetter;
import com.infradna.tool.bridge_method_injector.WithBridgeMethods;
import edu.umd.cs.findbugs.annotations.SuppressFBWarnings;
import java.io.IOException;
import java.time.Instant;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Date;
import java.util.List;
import java.util.Map;
import org.kohsuke.github.GHAppInstallation;
import org.kohsuke.github.GHCheckRun;
import org.kohsuke.github.GHCheckSuite;
import org.kohsuke.github.GHCommit;
import org.kohsuke.github.GHCommitComment;
import org.kohsuke.github.GHCommitState;
import org.kohsuke.github.GHDeployment;
import org.kohsuke.github.GHDeploymentStatus;
import org.kohsuke.github.GHException;
import org.kohsuke.github.GHIssue;
import org.kohsuke.github.GHIssueChanges;
import org.kohsuke.github.GHIssueComment;
import org.kohsuke.github.GHLabel;
import org.kohsuke.github.GHLabelChanges;
import org.kohsuke.github.GHMemberChanges;
import org.kohsuke.github.GHOrganization;
import org.kohsuke.github.GHProjectsV2Item;
import org.kohsuke.github.GHProjectsV2ItemChanges;
import org.kohsuke.github.GHPullRequest;
import org.kohsuke.github.GHPullRequestChanges;
import org.kohsuke.github.GHPullRequestReview;
import org.kohsuke.github.GHPullRequestReviewComment;
import org.kohsuke.github.GHRelease;
import org.kohsuke.github.GHRepository;
import org.kohsuke.github.GHRepositoryChanges;
import org.kohsuke.github.GHRepositoryDiscussion;
import org.kohsuke.github.GHRepositoryDiscussionComment;
import org.kohsuke.github.GHRequestedAction;
import org.kohsuke.github.GHTeam;
import org.kohsuke.github.GHTeamChanges;
import org.kohsuke.github.GHUser;
import org.kohsuke.github.GHWorkflow;
import org.kohsuke.github.GHWorkflowJob;
import org.kohsuke.github.GHWorkflowRun;
import org.kohsuke.github.GitHubClient;
import org.kohsuke.github.GitHubInteractiveObject;
import org.kohsuke.github.GitUser;

@SuppressFBWarnings(value={"UWF_UNWRITTEN_FIELD", "NP_UNWRITTEN_FIELD"}, justification="JSON API")
public abstract class GHEventPayload
extends GitHubInteractiveObject {
    private String action;
    private GHAppInstallation installation;
    private GHOrganization organization;
    private GHRepository repository;
    private GHUser sender;

    GHEventPayload() {
    }

    public String getAction() {
        return this.action;
    }

    @SuppressFBWarnings(value={"EI_EXPOSE_REP"}, justification="Expected")
    public GHAppInstallation getInstallation() {
        return this.installation;
    }

    @SuppressFBWarnings(value={"EI_EXPOSE_REP"}, justification="Expected")
    public GHOrganization getOrganization() {
        return this.organization;
    }

    @SuppressFBWarnings(value={"EI_EXPOSE_REP"}, justification="Expected")
    public GHRepository getRepository() {
        return this.repository;
    }

    @SuppressFBWarnings(value={"EI_EXPOSE_REP"}, justification="Expected")
    public GHUser getSender() {
        return this.sender;
    }

    void lateBind() {
    }

    public static class WorkflowRun
    extends GHEventPayload {
        private GHWorkflow workflow;
        private GHWorkflowRun workflowRun;

        @SuppressFBWarnings(value={"EI_EXPOSE_REP"}, justification="Expected")
        public GHWorkflow getWorkflow() {
            return this.workflow;
        }

        @SuppressFBWarnings(value={"EI_EXPOSE_REP"}, justification="Expected")
        public GHWorkflowRun getWorkflowRun() {
            return this.workflowRun;
        }

        @Override
        void lateBind() {
            if (this.workflowRun == null || this.workflow == null) {
                throw new IllegalStateException("Expected workflow and workflow_run payload, but got something else. Maybe we've got another type of event?");
            }
            super.lateBind();
            GHRepository repository = this.getRepository();
            if (repository == null) {
                throw new IllegalStateException("Repository must not be null");
            }
            this.workflowRun.wrapUp(repository);
            this.workflow.wrapUp(repository);
        }
    }

    public static class WorkflowJob
    extends GHEventPayload {
        private GHWorkflowJob workflowJob;

        @SuppressFBWarnings(value={"EI_EXPOSE_REP"}, justification="Expected")
        public GHWorkflowJob getWorkflowJob() {
            return this.workflowJob;
        }

        @Override
        void lateBind() {
            if (this.workflowJob == null) {
                throw new IllegalStateException("Expected workflow_job payload, but got something else.  Maybe we've got another type of event?");
            }
            super.lateBind();
            GHRepository repository = this.getRepository();
            if (repository == null) {
                throw new IllegalStateException("Repository must not be null");
            }
            this.workflowJob.wrapUp(repository);
        }
    }

    public static class WorkflowDispatch
    extends GHEventPayload {
        private Map<String, Object> inputs;
        private String ref;
        private String workflow;

        public Map<String, Object> getInputs() {
            return Collections.unmodifiableMap(this.inputs);
        }

        public String getRef() {
            return this.ref;
        }

        public String getWorkflow() {
            return this.workflow;
        }
    }

    public static class TeamAdd
    extends GHEventPayload {
        private GHTeam team;

        @SuppressFBWarnings(value={"EI_EXPOSE_REP"}, justification="Expected")
        public GHTeam getTeam() {
            return this.team;
        }

        @Override
        void lateBind() {
            if (this.team == null) {
                throw new IllegalStateException("Expected team payload, but got something else. Maybe we've got another type of event?");
            }
            super.lateBind();
            GHOrganization organization = this.getOrganization();
            if (organization == null) {
                throw new IllegalStateException("Organization must not be null");
            }
            this.team.wrapUp(organization);
        }
    }

    public static class Team
    extends GHEventPayload {
        private GHTeamChanges changes;
        private GHTeam team;

        public GHTeamChanges getChanges() {
            return this.changes;
        }

        @SuppressFBWarnings(value={"EI_EXPOSE_REP"}, justification="Expected")
        public GHTeam getTeam() {
            return this.team;
        }

        @Override
        void lateBind() {
            if (this.team == null) {
                throw new IllegalStateException("Expected team payload, but got something else. Maybe we've got another type of event?");
            }
            super.lateBind();
            GHOrganization organization = this.getOrganization();
            if (organization == null) {
                throw new IllegalStateException("Organization must not be null");
            }
            this.team.wrapUp(organization);
        }
    }

    public static class Status
    extends GHEventPayload {
        private GHCommit commit;
        private String context;
        private String description;
        private GHCommitState state;
        private String targetUrl;

        @SuppressFBWarnings(value={"EI_EXPOSE_REP"}, justification="Expected")
        public GHCommit getCommit() {
            return this.commit;
        }

        public String getContext() {
            return this.context;
        }

        public String getDescription() {
            return this.description;
        }

        public GHCommitState getState() {
            return this.state;
        }

        public String getTargetUrl() {
            return this.targetUrl;
        }

        @Override
        void lateBind() {
            if (this.state == null) {
                throw new IllegalStateException("Expected status payload, but got something else. Maybe we've got another type of event?");
            }
            super.lateBind();
            GHRepository repository = this.getRepository();
            if (repository != null) {
                this.commit.wrapUp(repository);
            }
        }
    }

    public static class Star
    extends GHEventPayload {
        private String starredAt;

        @WithBridgeMethods(value={Date.class}, adapterMethod="instantToDate")
        public Instant getStarredAt() {
            return GitHubClient.parseInstant(this.starredAt);
        }
    }

    public static class Repository
    extends GHEventPayload {
        private GHRepositoryChanges changes;

        public GHRepositoryChanges getChanges() {
            return this.changes;
        }
    }

    @SuppressFBWarnings(value={"UWF_FIELD_NOT_INITIALIZED_IN_CONSTRUCTOR", "NP_UNWRITTEN_FIELD"}, justification="Constructed by JSON deserialization")
    public static class Release
    extends GHEventPayload {
        private GHRelease release;

        @SuppressFBWarnings(value={"EI_EXPOSE_REP"}, justification="Expected")
        public GHRelease getRelease() {
            return this.release;
        }
    }

    public static class Push
    extends GHEventPayload {
        private List<PushCommit> commits;
        private String compare;
        private boolean created;
        private boolean deleted;
        private boolean forced;
        private String head;
        private String before;
        private PushCommit headCommit;
        private Pusher pusher;
        private String ref;
        private int size;

        public String getBefore() {
            return this.before;
        }

        public List<PushCommit> getCommits() {
            return Collections.unmodifiableList(this.commits);
        }

        public String getCompare() {
            return this.compare;
        }

        public String getHead() {
            return this.head;
        }

        @SuppressFBWarnings(value={"EI_EXPOSE_REP"}, justification="Expected")
        public PushCommit getHeadCommit() {
            return this.headCommit;
        }

        @SuppressFBWarnings(value={"EI_EXPOSE_REP"}, justification="Expected")
        public Pusher getPusher() {
            return this.pusher;
        }

        public String getRef() {
            return this.ref;
        }

        public int getSize() {
            return this.size;
        }

        public boolean isCreated() {
            return this.created;
        }

        public boolean isDeleted() {
            return this.deleted;
        }

        public boolean isForced() {
            return this.forced;
        }

        @JsonSetter
        private void setAfter(String after) {
            this.head = after;
        }

        public static class PushCommit {
            private List<String> added;
            private List<String> removed;
            private List<String> modified;
            private GitUser author;
            private GitUser committer;
            private boolean distinct;
            private String url;
            private String sha;
            private String message;
            private String timestamp;

            public List<String> getAdded() {
                return Collections.unmodifiableList(this.added);
            }

            public GitUser getAuthor() {
                return this.author;
            }

            public GitUser getCommitter() {
                return this.committer;
            }

            public String getMessage() {
                return this.message;
            }

            public List<String> getModified() {
                return Collections.unmodifiableList(this.modified);
            }

            public List<String> getRemoved() {
                return Collections.unmodifiableList(this.removed);
            }

            public String getSha() {
                return this.sha;
            }

            @WithBridgeMethods(value={Date.class}, adapterMethod="instantToDate")
            public Instant getTimestamp() {
                return GitHubClient.parseInstant(this.timestamp);
            }

            public String getUrl() {
                return this.url;
            }

            public boolean isDistinct() {
                return this.distinct;
            }

            @JsonSetter
            private void setId(String id) {
                this.sha = id;
            }
        }

        public static class Pusher {
            private String name;
            private String email;

            public String getEmail() {
                return this.email;
            }

            public String getName() {
                return this.name;
            }
        }
    }

    public static class PullRequestReviewComment
    extends GHEventPayload {
        private CommentChanges changes;
        private GHPullRequestReviewComment comment;
        private GHPullRequest pullRequest;

        public CommentChanges getChanges() {
            return this.changes;
        }

        @SuppressFBWarnings(value={"EI_EXPOSE_REP"}, justification="Expected")
        public GHPullRequestReviewComment getComment() {
            return this.comment;
        }

        @SuppressFBWarnings(value={"EI_EXPOSE_REP"}, justification="Expected")
        public GHPullRequest getPullRequest() {
            return this.pullRequest;
        }

        @Override
        void lateBind() {
            if (this.comment == null) {
                throw new IllegalStateException("Expected pull_request_review_comment payload, but got something else. Maybe we've got another type of event?");
            }
            super.lateBind();
            this.comment.wrapUp(this.pullRequest);
            GHRepository repository = this.getRepository();
            if (repository != null) {
                this.pullRequest.wrapUp(repository);
            }
        }
    }

    public static class PullRequestReview
    extends GHEventPayload {
        private GHPullRequest pullRequest;
        private GHPullRequestReview review;

        @SuppressFBWarnings(value={"EI_EXPOSE_REP"}, justification="Expected")
        public GHPullRequest getPullRequest() {
            return this.pullRequest;
        }

        @SuppressFBWarnings(value={"EI_EXPOSE_REP"}, justification="Expected")
        public GHPullRequestReview getReview() {
            return this.review;
        }

        @Override
        void lateBind() {
            if (this.review == null) {
                throw new IllegalStateException("Expected pull_request_review payload, but got something else. Maybe we've got another type of event?");
            }
            super.lateBind();
            this.review.wrapUp(this.pullRequest);
            GHRepository repository = this.getRepository();
            if (repository != null) {
                this.pullRequest.wrapUp(repository);
            }
        }
    }

    @SuppressFBWarnings(value={"NP_UNWRITTEN_FIELD"}, justification="JSON API")
    public static class PullRequest
    extends GHEventPayload {
        private GHPullRequestChanges changes;
        private GHLabel label;
        private int number;
        private GHPullRequest pullRequest;

        @SuppressFBWarnings(value={"EI_EXPOSE_REP"}, justification="Expected")
        public GHPullRequestChanges getChanges() {
            return this.changes;
        }

        @SuppressFBWarnings(value={"EI_EXPOSE_REP"}, justification="Expected")
        public GHLabel getLabel() {
            return this.label;
        }

        public int getNumber() {
            return this.number;
        }

        @SuppressFBWarnings(value={"EI_EXPOSE_REP"}, justification="Expected")
        public GHPullRequest getPullRequest() {
            return this.pullRequest;
        }

        @Override
        void lateBind() {
            if (this.pullRequest == null) {
                throw new IllegalStateException("Expected pull_request payload, but got something else. Maybe we've got another type of event?");
            }
            super.lateBind();
            GHRepository repository = this.getRepository();
            if (repository != null) {
                this.pullRequest.wrapUp(repository);
            }
        }
    }

    public static class Public
    extends GHEventPayload {
    }

    public static class ProjectsV2Item
    extends GHEventPayload {
        private GHProjectsV2ItemChanges changes;
        private GHProjectsV2Item projectsV2Item;

        public GHProjectsV2ItemChanges getChanges() {
            return this.changes;
        }

        @SuppressFBWarnings(value={"EI_EXPOSE_REP"}, justification="Expected")
        public GHProjectsV2Item getProjectsV2Item() {
            return this.projectsV2Item;
        }
    }

    public static class Ping
    extends GHEventPayload {
    }

    public static class Membership
    extends GHEventPayload {
        private GHUser member;
        private GHTeam team;

        @SuppressFBWarnings(value={"EI_EXPOSE_REP"}, justification="Expected")
        public GHUser getMember() {
            return this.member;
        }

        @SuppressFBWarnings(value={"EI_EXPOSE_REP"}, justification="Expected")
        public GHTeam getTeam() {
            return this.team;
        }

        @Override
        void lateBind() {
            if (this.team == null) {
                throw new IllegalStateException("Expected membership payload, but got something else. Maybe we've got another type of event?");
            }
            super.lateBind();
            GHOrganization organization = this.getOrganization();
            if (organization == null) {
                throw new IllegalStateException("Organization must not be null");
            }
            this.team.wrapUp(organization);
        }
    }

    public static class Member
    extends GHEventPayload {
        private GHMemberChanges changes;
        private GHUser member;

        public GHMemberChanges getChanges() {
            return this.changes;
        }

        @SuppressFBWarnings(value={"EI_EXPOSE_REP"}, justification="Expected")
        public GHUser getMember() {
            return this.member;
        }
    }

    public static class Label
    extends GHEventPayload {
        private GHLabelChanges changes;
        private GHLabel label;

        public GHLabelChanges getChanges() {
            return this.changes;
        }

        @SuppressFBWarnings(value={"EI_EXPOSE_REP"}, justification="Expected behavior")
        public GHLabel getLabel() {
            return this.label;
        }
    }

    public static class IssueComment
    extends GHEventPayload {
        private CommentChanges changes;
        private GHIssueComment comment;
        private GHIssue issue;

        public CommentChanges getChanges() {
            return this.changes;
        }

        @SuppressFBWarnings(value={"EI_EXPOSE_REP"}, justification="Expected")
        public GHIssueComment getComment() {
            return this.comment;
        }

        @SuppressFBWarnings(value={"EI_EXPOSE_REP"}, justification="Expected")
        public GHIssue getIssue() {
            return this.issue;
        }

        @Override
        void lateBind() {
            super.lateBind();
            GHRepository repository = this.getRepository();
            if (repository != null) {
                this.issue.wrap(repository);
            }
            this.comment.wrapUp(this.issue);
        }
    }

    public static class Issue
    extends GHEventPayload {
        private GHIssueChanges changes;
        private GHIssue issue;
        private GHLabel label;

        @SuppressFBWarnings(value={"EI_EXPOSE_REP"}, justification="Expected")
        public GHIssueChanges getChanges() {
            return this.changes;
        }

        @SuppressFBWarnings(value={"EI_EXPOSE_REP"}, justification="Expected")
        public GHIssue getIssue() {
            return this.issue;
        }

        @SuppressFBWarnings(value={"EI_EXPOSE_REP"}, justification="Expected")
        public GHLabel getLabel() {
            return this.label;
        }

        @Override
        void lateBind() {
            super.lateBind();
            GHRepository repository = this.getRepository();
            if (repository != null) {
                this.issue.wrap(repository);
            }
        }
    }

    public static class InstallationRepositories
    extends GHEventPayload {
        private List<GHRepository> repositoriesAdded;
        private List<GHRepository> repositoriesRemoved;
        private String repositorySelection;

        public List<GHRepository> getRepositoriesAdded() {
            return Collections.unmodifiableList(this.repositoriesAdded);
        }

        public List<GHRepository> getRepositoriesRemoved() {
            return Collections.unmodifiableList(this.repositoriesRemoved);
        }

        public String getRepositorySelection() {
            return this.repositorySelection;
        }

        @Override
        void lateBind() {
            if (this.getInstallation() == null) {
                throw new IllegalStateException("Expected installation_repositories payload, but got something else. Maybe we've got another type of event?");
            }
            super.lateBind();
            List<GHRepository> repositories = "added".equals(this.getAction()) ? this.repositoriesAdded : this.repositoriesRemoved;
            if (repositories != null && !repositories.isEmpty()) {
                try {
                    for (GHRepository singleRepo : repositories) {
                        singleRepo.populate();
                    }
                }
                catch (IOException e) {
                    throw new GHException("Failed to refresh repositories", e);
                }
            }
        }
    }

    public static class Installation
    extends GHEventPayload {
        private List<GHRepository> ghRepositories = null;
        private List<Repository> repositories;

        public List<Repository> getRawRepositories() {
            return Collections.unmodifiableList(this.repositories);
        }

        public List<GHRepository> getRepositories() {
            if ("deleted".equalsIgnoreCase(this.getAction())) {
                throw new IllegalStateException("Can't call #getRepositories() on Installation event with 'deleted' action. Call #getRawRepositories() instead.");
            }
            if (this.ghRepositories == null) {
                this.ghRepositories = new ArrayList<GHRepository>(this.repositories.size());
                try {
                    for (Repository singleRepo : this.repositories) {
                        this.ghRepositories.add(this.root().getRepositoryById(singleRepo.getId()));
                    }
                }
                catch (IOException e) {
                    throw new GHException("Failed to refresh repositories", e);
                }
            }
            return Collections.unmodifiableList(this.ghRepositories);
        }

        @Override
        void lateBind() {
            if (this.getInstallation() == null) {
                throw new IllegalStateException("Expected installation payload, but got something else. Maybe we've got another type of event?");
            }
            super.lateBind();
        }

        public static class Repository {
            private String fullName;
            private long id;
            @JsonProperty(value="private")
            private boolean isPrivate;
            private String name;
            private String nodeId;

            public String getFullName() {
                return this.fullName;
            }

            public long getId() {
                return this.id;
            }

            public String getName() {
                return this.name;
            }

            public String getNodeId() {
                return this.nodeId;
            }

            public boolean isPrivate() {
                return this.isPrivate;
            }
        }
    }

    public static class Fork
    extends GHEventPayload {
        private GHRepository forkee;

        @SuppressFBWarnings(value={"EI_EXPOSE_REP"}, justification="Expected")
        public GHRepository getForkee() {
            return this.forkee;
        }
    }

    public static class DiscussionComment
    extends GHEventPayload {
        private GHRepositoryDiscussionComment comment;
        private GHRepositoryDiscussion discussion;

        @SuppressFBWarnings(value={"EI_EXPOSE_REP"}, justification="Expected")
        public GHRepositoryDiscussionComment getComment() {
            return this.comment;
        }

        @SuppressFBWarnings(value={"EI_EXPOSE_REP"}, justification="Expected")
        public GHRepositoryDiscussion getDiscussion() {
            return this.discussion;
        }
    }

    public static class Discussion
    extends GHEventPayload {
        private GHRepositoryDiscussion discussion;
        private GHLabel label;

        @SuppressFBWarnings(value={"EI_EXPOSE_REP"}, justification="Expected")
        public GHRepositoryDiscussion getDiscussion() {
            return this.discussion;
        }

        @SuppressFBWarnings(value={"EI_EXPOSE_REP"}, justification="Expected")
        public GHLabel getLabel() {
            return this.label;
        }
    }

    public static class DeploymentStatus
    extends GHEventPayload {
        private GHDeployment deployment;
        private GHDeploymentStatus deploymentStatus;

        @SuppressFBWarnings(value={"EI_EXPOSE_REP"}, justification="Expected")
        public GHDeployment getDeployment() {
            return this.deployment;
        }

        @SuppressFBWarnings(value={"EI_EXPOSE_REP"}, justification="Expected")
        public GHDeploymentStatus getDeploymentStatus() {
            return this.deploymentStatus;
        }

        @Override
        void lateBind() {
            super.lateBind();
            GHRepository repository = this.getRepository();
            if (repository != null) {
                this.deployment.wrap(repository);
                this.deploymentStatus.lateBind(repository);
            }
        }
    }

    public static class Deployment
    extends GHEventPayload {
        private GHDeployment deployment;

        @SuppressFBWarnings(value={"EI_EXPOSE_REP"}, justification="Expected")
        public GHDeployment getDeployment() {
            return this.deployment;
        }

        @Override
        void lateBind() {
            super.lateBind();
            GHRepository repository = this.getRepository();
            if (repository != null) {
                this.deployment.wrap(repository);
            }
        }
    }

    public static class Delete
    extends GHEventPayload {
        private String ref;
        private String refType;

        public String getRef() {
            return this.ref;
        }

        public String getRefType() {
            return this.refType;
        }
    }

    public static class Create
    extends GHEventPayload {
        private String description;
        private String masterBranch;
        private String ref;
        private String refType;

        public String getDescription() {
            return this.description;
        }

        public String getMasterBranch() {
            return this.masterBranch;
        }

        public String getRef() {
            return this.ref;
        }

        public String getRefType() {
            return this.refType;
        }
    }

    public static class CommitComment
    extends GHEventPayload {
        private GHCommitComment comment;

        @SuppressFBWarnings(value={"EI_EXPOSE_REP"}, justification="Expected")
        public GHCommitComment getComment() {
            return this.comment;
        }

        @Override
        void lateBind() {
            super.lateBind();
            GHRepository repository = this.getRepository();
            if (repository != null) {
                this.comment.wrap(repository);
            }
        }
    }

    @SuppressFBWarnings(value={"UWF_UNWRITTEN_FIELD"}, justification="JSON API")
    public static class CommentChanges {
        private GHFrom body;

        public GHFrom getBody() {
            return this.body;
        }

        public static class GHFrom {
            private String from;

            public String getFrom() {
                return this.from;
            }
        }
    }

    public static class CheckSuite
    extends GHEventPayload {
        private GHCheckSuite checkSuite;

        @SuppressFBWarnings(value={"EI_EXPOSE_REP"}, justification="Expected")
        public GHCheckSuite getCheckSuite() {
            return this.checkSuite;
        }

        @Override
        void lateBind() {
            if (this.checkSuite == null) {
                throw new IllegalStateException("Expected check_suite payload, but got something else. Maybe we've got another type of event?");
            }
            super.lateBind();
            GHRepository repository = this.getRepository();
            if (repository != null) {
                this.checkSuite.wrap(repository);
            } else {
                this.checkSuite.wrap(this.root());
            }
        }
    }

    public static class CheckRun
    extends GHEventPayload {
        private GHCheckRun checkRun;
        private int number;
        private GHRequestedAction requestedAction;

        @SuppressFBWarnings(value={"EI_EXPOSE_REP"}, justification="Expected")
        public GHCheckRun getCheckRun() {
            return this.checkRun;
        }

        public int getNumber() {
            return this.number;
        }

        @SuppressFBWarnings(value={"EI_EXPOSE_REP"}, justification="Expected")
        public GHRequestedAction getRequestedAction() {
            return this.requestedAction;
        }

        @Override
        void lateBind() {
            if (this.checkRun == null) {
                throw new IllegalStateException("Expected check_run payload, but got something else. Maybe we've got another type of event?");
            }
            super.lateBind();
            GHRepository repository = this.getRepository();
            if (repository != null) {
                this.checkRun.wrap(repository);
            } else {
                this.checkRun.wrap(this.root());
            }
        }
    }
}

