/*
 * Decompiled with CFR 0.152.
 */
package org.kohsuke.github;

import com.fasterxml.jackson.annotation.JsonProperty;
import com.infradna.tool.bridge_method_injector.WithBridgeMethods;
import edu.umd.cs.findbugs.annotations.SuppressFBWarnings;
import java.io.IOException;
import java.net.URL;
import java.time.Instant;
import java.util.Arrays;
import java.util.Collections;
import java.util.Date;
import java.util.List;
import org.kohsuke.github.GHApp;
import org.kohsuke.github.GHObject;
import org.kohsuke.github.GHPullRequest;
import org.kohsuke.github.GHRepository;
import org.kohsuke.github.GitHub;
import org.kohsuke.github.GitHubBridgeAdapterObject;
import org.kohsuke.github.GitHubClient;
import org.kohsuke.github.GitUser;

@SuppressFBWarnings(value={"UWF_UNWRITTEN_FIELD", "NP_UNWRITTEN_FIELD", "URF_UNREAD_FIELD"}, justification="JSON API")
public class GHCheckSuite
extends GHObject {
    private String after;
    private GHApp app;
    private String before;
    private String checkRunsUrl;
    private String conclusion;
    private String headBranch;
    private HeadCommit headCommit;
    private String headSha;
    private int latestCheckRunsCount;
    private String nodeId;
    private GHPullRequest[] pullRequests;
    private String status;
    @JsonProperty(value="repository")
    GHRepository owner;

    public String getAfter() {
        return this.after;
    }

    @SuppressFBWarnings(value={"EI_EXPOSE_REP"}, justification="Expected behavior")
    public GHApp getApp() {
        return this.app;
    }

    public String getBefore() {
        return this.before;
    }

    public URL getCheckRunsUrl() {
        return GitHubClient.parseURL(this.checkRunsUrl);
    }

    public String getConclusion() {
        return this.conclusion;
    }

    public String getHeadBranch() {
        return this.headBranch;
    }

    public HeadCommit getHeadCommit() {
        return this.headCommit;
    }

    public String getHeadSha() {
        return this.headSha;
    }

    public int getLatestCheckRunsCount() {
        return this.latestCheckRunsCount;
    }

    @Override
    public String getNodeId() {
        return this.nodeId;
    }

    public List<GHPullRequest> getPullRequests() throws IOException {
        if (this.pullRequests != null && this.pullRequests.length != 0) {
            for (GHPullRequest singlePull : this.pullRequests) {
                singlePull.refresh(singlePull.getTitle());
            }
            return Collections.unmodifiableList(Arrays.asList(this.pullRequests));
        }
        return Collections.emptyList();
    }

    public String getStatus() {
        return this.status;
    }

    GHPullRequest[] wrap() {
        return this.pullRequests;
    }

    GHCheckSuite wrap(GHRepository owner) {
        this.owner = owner;
        this.wrap(owner.root());
        return this;
    }

    GHCheckSuite wrap(GitHub root) {
        if (this.owner != null && this.pullRequests != null && this.pullRequests.length != 0) {
            for (GHPullRequest singlePull : this.pullRequests) {
                singlePull.wrap(this.owner);
            }
        }
        return this;
    }

    public static class HeadCommit
    extends GitHubBridgeAdapterObject {
        private GitUser author;
        private GitUser committer;
        private String id;
        private String message;
        private String timestamp;
        private String treeId;

        public GitUser getAuthor() {
            return this.author;
        }

        public GitUser getCommitter() {
            return this.committer;
        }

        public String getId() {
            return this.id;
        }

        public String getMessage() {
            return this.message;
        }

        @WithBridgeMethods(value={Date.class}, adapterMethod="instantToDate")
        public Instant getTimestamp() {
            return GitHubClient.parseInstant(this.timestamp);
        }

        public String getTreeId() {
            return this.treeId;
        }
    }
}

