/*
 * Decompiled with CFR 0.152.
 */
package org.kohsuke.github;

import java.io.IOException;
import org.kohsuke.github.GHAutolink;
import org.kohsuke.github.GHRepository;
import org.kohsuke.github.Requester;

public class GHAutolinkBuilder {
    private Boolean isAlphanumeric;
    private String keyPrefix;
    private final GHRepository repo;
    private final Requester req;
    private String urlTemplate;

    GHAutolinkBuilder(GHRepository repo) {
        this.repo = repo;
        this.req = repo.root().createRequest();
    }

    public GHAutolink create() throws IOException {
        GHAutolink autolink = ((Requester)((Requester)((Requester)((Requester)((Requester)((Requester)this.req.method("POST")).with("key_prefix", this.keyPrefix)).with("url_template", this.urlTemplate)).with("is_alphanumeric", this.isAlphanumeric)).withHeader("Accept", "application/vnd.github+json")).withUrlPath(this.getApiTail(), new String[0])).fetch(GHAutolink.class);
        return autolink.lateBind(this.repo);
    }

    public GHAutolinkBuilder withIsAlphanumeric(boolean isAlphanumeric) {
        this.isAlphanumeric = isAlphanumeric;
        return this;
    }

    public GHAutolinkBuilder withKeyPrefix(String keyPrefix) {
        this.keyPrefix = keyPrefix;
        return this;
    }

    public GHAutolinkBuilder withUrlTemplate(String urlTemplate) {
        this.urlTemplate = urlTemplate;
        return this;
    }

    private String getApiTail() {
        return String.format("/repos/%s/%s/autolinks", this.repo.getOwnerName(), this.repo.getName());
    }
}

