/*
 * Decompiled with CFR 0.152.
 */
package org.kohsuke.github;

import java.io.IOException;
import java.io.InterruptedIOException;
import java.time.Duration;
import java.time.ZonedDateTime;
import java.time.format.DateTimeFormatter;
import java.time.temporal.ChronoUnit;
import javax.annotation.Nonnull;
import org.kohsuke.github.GitHubConnectorResponseErrorHandler;
import org.kohsuke.github.HttpException;
import org.kohsuke.github.connector.GitHubConnectorResponse;

public abstract class GitHubAbuseLimitHandler
extends GitHubConnectorResponseErrorHandler {
    private static final int MINIMUM_ABUSE_RETRY_MILLIS = 1000;
    public static final GitHubAbuseLimitHandler WAIT = new GitHubAbuseLimitHandler(){

        @Override
        public void onError(GitHubConnectorResponse connectorResponse) throws IOException {
            try {
                Thread.sleep(1.parseWaitTime(connectorResponse));
            }
            catch (InterruptedException ex) {
                throw (InterruptedIOException)new InterruptedIOException().initCause(ex);
            }
        }
    };
    public static final GitHubAbuseLimitHandler FAIL = new GitHubAbuseLimitHandler(){

        @Override
        public void onError(GitHubConnectorResponse connectorResponse) throws IOException {
            throw new HttpException("Abuse limit reached", connectorResponse.statusCode(), connectorResponse.header("Status"), connectorResponse.request().url().toString()).withResponseHeaderFields(connectorResponse.allHeaders());
        }
    };
    static long DEFAULT_WAIT_MILLIS = Duration.ofSeconds(61L).toMillis();

    @Override
    boolean isError(@Nonnull GitHubConnectorResponse connectorResponse) {
        return this.isTooManyRequests(connectorResponse) || this.isForbidden(connectorResponse) && this.hasRetryOrLimitHeader(connectorResponse);
    }

    private boolean isTooManyRequests(GitHubConnectorResponse connectorResponse) {
        return connectorResponse.statusCode() == 429;
    }

    private boolean isForbidden(GitHubConnectorResponse connectorResponse) {
        return connectorResponse.statusCode() == 403;
    }

    private boolean hasRetryOrLimitHeader(GitHubConnectorResponse connectorResponse) {
        return this.hasHeader(connectorResponse, "Retry-After") || this.hasHeader(connectorResponse, "gh-limited-by");
    }

    private boolean hasHeader(GitHubConnectorResponse connectorResponse, String headerName) {
        return connectorResponse.header(headerName) != null;
    }

    @Override
    public abstract void onError(@Nonnull GitHubConnectorResponse var1) throws IOException;

    static long parseWaitTime(GitHubConnectorResponse connectorResponse) {
        String v = connectorResponse.header("Retry-After");
        if (v == null) {
            return DEFAULT_WAIT_MILLIS;
        }
        try {
            return Math.max(1000L, Duration.ofSeconds(Long.parseLong(v)).toMillis());
        }
        catch (NumberFormatException nfe) {
            String dateField = connectorResponse.header("Date");
            ZonedDateTime now = dateField != null ? ZonedDateTime.parse(dateField, DateTimeFormatter.RFC_1123_DATE_TIME) : ZonedDateTime.now();
            ZonedDateTime zdt = ZonedDateTime.parse(v, DateTimeFormatter.RFC_1123_DATE_TIME);
            return Math.max(1000L, ChronoUnit.MILLIS.between(now, zdt));
        }
    }
}

