/*
 * Decompiled with CFR 0.152.
 */
package org.kohsuke.github;

import edu.umd.cs.findbugs.annotations.SuppressFBWarnings;
import java.net.URL;
import org.kohsuke.github.GHPullRequest;
import org.kohsuke.github.GitHubClient;
import org.kohsuke.github.GitUser;

@SuppressFBWarnings(value={"UWF_UNWRITTEN_PUBLIC_OR_PROTECTED_FIELD", "UWF_UNWRITTEN_FIELD", "NP_UNWRITTEN_FIELD", "URF_UNREAD_FIELD"}, justification="JSON API")
public class GHPullRequestCommitDetail {
    private GHPullRequest owner;
    String sha;
    Commit commit;
    String url;
    String htmlUrl;
    String commentsUrl;
    CommitPointer[] parents;

    void wrapUp(GHPullRequest owner) {
        this.owner = owner;
    }

    public String getSha() {
        return this.sha;
    }

    public Commit getCommit() {
        return this.commit;
    }

    public URL getApiUrl() {
        return GitHubClient.parseURL(this.url);
    }

    public URL getUrl() {
        return GitHubClient.parseURL(this.htmlUrl);
    }

    public URL getCommentsUrl() {
        return GitHubClient.parseURL(this.commentsUrl);
    }

    public CommitPointer[] getParents() {
        CommitPointer[] newValue = new CommitPointer[this.parents.length];
        System.arraycopy(this.parents, 0, newValue, 0, this.parents.length);
        return newValue;
    }

    public static class Commit {
        GitUser author;
        GitUser committer;
        String message;
        Tree tree;
        String url;
        Integer commentCount;

        public GitUser getAuthor() {
            return this.author;
        }

        public GitUser getCommitter() {
            return this.committer;
        }

        public String getMessage() {
            return this.message;
        }

        public URL getUrl() {
            return GitHubClient.parseURL(this.url);
        }

        @Deprecated
        public int getComment_count() {
            return this.getCommentCount();
        }

        public Integer getCommentCount() {
            return this.commentCount;
        }

        public Tree getTree() {
            return this.tree;
        }
    }

    public static class CommitPointer {
        String sha;
        String url;
        String htmlUrl;

        public URL getUrl() {
            return GitHubClient.parseURL(this.url);
        }

        public URL getHtmlUrl() {
            return GitHubClient.parseURL(this.htmlUrl);
        }

        @Deprecated
        public URL getHtml_url() {
            return this.getHtmlUrl();
        }

        public String getSha() {
            return this.sha;
        }
    }

    public static class Tree {
        String sha;
        String url;

        public String getSha() {
            return this.sha;
        }

        public URL getUrl() {
            return GitHubClient.parseURL(this.url);
        }
    }
}

