/*
 * Decompiled with CFR 0.152.
 */
package org.kohsuke.github;

import com.infradna.tool.bridge_method_injector.WithBridgeMethods;
import edu.umd.cs.findbugs.annotations.SuppressFBWarnings;
import java.io.IOException;
import java.net.URL;
import java.time.Instant;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Date;
import java.util.List;
import java.util.Objects;
import org.apache.commons.lang3.StringUtils;
import org.kohsuke.github.GHCommitPointer;
import org.kohsuke.github.GHIssue;
import org.kohsuke.github.GHPullRequestCommitDetail;
import org.kohsuke.github.GHPullRequestFileDetail;
import org.kohsuke.github.GHPullRequestReview;
import org.kohsuke.github.GHPullRequestReviewBuilder;
import org.kohsuke.github.GHPullRequestReviewComment;
import org.kohsuke.github.GHPullRequestReviewCommentBuilder;
import org.kohsuke.github.GHRepository;
import org.kohsuke.github.GHTeam;
import org.kohsuke.github.GHUser;
import org.kohsuke.github.GitHubClient;
import org.kohsuke.github.GitHubRequest;
import org.kohsuke.github.PagedIterable;
import org.kohsuke.github.Refreshable;
import org.kohsuke.github.Requester;

public class GHPullRequest
extends GHIssue
implements Refreshable {
    private static final String COMMENTS_ACTION = "/comments";
    private static final String REQUEST_REVIEWERS = "/requested_reviewers";
    private String patchUrl;
    private String diffUrl;
    private String issueUrl;
    private GHCommitPointer base;
    private String mergedAt;
    private GHCommitPointer head;
    private GHUser mergedBy;
    private int reviewComments;
    private int additions;
    private int commits;
    private boolean merged;
    private boolean maintainerCanModify;
    boolean draft;
    private Boolean mergeable;
    private int deletions;
    private String mergeableState;
    private int changedFiles;
    private String mergeCommitSha;
    private AutoMerge autoMerge;
    private GHUser[] requestedReviewers;
    private GHTeam[] requestedTeams;

    GHPullRequest wrapUp(GHRepository owner) {
        this.wrap(owner);
        return this;
    }

    @Override
    protected String getApiRoute() {
        if (this.owner == null) {
            URL url = Objects.requireNonNull(this.getUrl(), "Missing instance URL!");
            return StringUtils.prependIfMissing((String)url.toString().replace(this.root().getApiUrl(), ""), (CharSequence)"/", (CharSequence[])new CharSequence[0]).replace("/issues/", "/pulls/");
        }
        return "/repos/" + this.owner.getOwnerName() + "/" + this.owner.getName() + "/pulls/" + this.number;
    }

    public AutoMerge getAutoMerge() {
        return this.autoMerge;
    }

    public URL getPatchUrl() {
        return GitHubClient.parseURL(this.patchUrl);
    }

    public URL getIssueUrl() {
        return GitHubClient.parseURL(this.issueUrl);
    }

    public GHCommitPointer getBase() {
        return this.base;
    }

    public GHCommitPointer getHead() {
        return this.head;
    }

    public URL getDiffUrl() {
        return GitHubClient.parseURL(this.diffUrl);
    }

    @WithBridgeMethods(value={Date.class}, adapterMethod="instantToDate")
    public Instant getMergedAt() {
        return GitHubClient.parseInstant(this.mergedAt);
    }

    @Override
    public GHUser getClosedBy() {
        return null;
    }

    @Override
    public GHIssue.PullRequest getPullRequest() {
        return null;
    }

    @SuppressFBWarnings(value={"EI_EXPOSE_REP"}, justification="Expected behavior")
    public GHUser getMergedBy() throws IOException {
        this.populate();
        return this.mergedBy;
    }

    public int getReviewComments() throws IOException {
        this.populate();
        return this.reviewComments;
    }

    public int getAdditions() throws IOException {
        this.populate();
        return this.additions;
    }

    public int getCommits() throws IOException {
        this.populate();
        return this.commits;
    }

    public boolean isMerged() throws IOException {
        this.populate();
        return this.merged;
    }

    public boolean canMaintainerModify() throws IOException {
        this.populate();
        return this.maintainerCanModify;
    }

    public boolean isDraft() throws IOException {
        this.populate();
        return this.draft;
    }

    public Boolean getMergeable() throws IOException {
        this.refresh(this.mergeable);
        return this.mergeable;
    }

    Boolean getMergeableNoRefresh() {
        return this.mergeable;
    }

    public int getDeletions() throws IOException {
        this.populate();
        return this.deletions;
    }

    public String getMergeableState() throws IOException {
        this.populate();
        return this.mergeableState;
    }

    public int getChangedFiles() throws IOException {
        this.populate();
        return this.changedFiles;
    }

    public String getMergeCommitSha() throws IOException {
        this.populate();
        return this.mergeCommitSha;
    }

    public List<GHUser> getRequestedReviewers() throws IOException {
        this.refresh(this.requestedReviewers);
        return Collections.unmodifiableList(Arrays.asList(this.requestedReviewers));
    }

    public List<GHTeam> getRequestedTeams() throws IOException {
        this.refresh(this.requestedTeams);
        return Collections.unmodifiableList(Arrays.asList(this.requestedTeams));
    }

    private void populate() throws IOException {
        if (this.mergeableState != null) {
            return;
        }
        this.refresh();
    }

    @Override
    public void refresh() throws IOException {
        if (this.isOffline()) {
            return;
        }
        URL absoluteUrl = GitHubRequest.getApiURL(this.root().getApiUrl(), this.getApiRoute());
        ((Requester)this.root().createRequest().setRawUrlPath(absoluteUrl.toString())).fetchInto(this).wrapUp(this.owner);
    }

    public PagedIterable<GHPullRequestFileDetail> listFiles() {
        return ((Requester)this.root().createRequest().withUrlPath(String.format("%s/files", this.getApiRoute()), new String[0])).toIterable(GHPullRequestFileDetail[].class, null);
    }

    public PagedIterable<GHPullRequestReview> listReviews() {
        return ((Requester)this.root().createRequest().withUrlPath(String.format("%s/reviews", this.getApiRoute()), new String[0])).toIterable(GHPullRequestReview[].class, item -> item.wrapUp(this));
    }

    public PagedIterable<GHPullRequestReviewComment> listReviewComments() {
        return ((Requester)this.root().createRequest().withUrlPath(this.getApiRoute() + COMMENTS_ACTION, new String[0])).toIterable(GHPullRequestReviewComment[].class, item -> item.wrapUp(this));
    }

    public PagedIterable<GHPullRequestCommitDetail> listCommits() {
        return ((Requester)this.root().createRequest().withUrlPath(String.format("%s/commits", this.getApiRoute()), new String[0])).toIterable(GHPullRequestCommitDetail[].class, item -> item.wrapUp(this));
    }

    public GHPullRequestReviewBuilder createReview() {
        return new GHPullRequestReviewBuilder(this);
    }

    public GHPullRequestReviewCommentBuilder createReviewComment() {
        return new GHPullRequestReviewCommentBuilder(this);
    }

    @Deprecated
    public GHPullRequestReviewComment createReviewComment(String body, String sha, String path, int position) throws IOException {
        return this.createReviewComment().body(body).commitId(sha).path(path).position(position).create();
    }

    public void requestReviewers(List<GHUser> reviewers) throws IOException {
        ((Requester)((Requester)((Requester)this.root().createRequest().method("POST")).with("reviewers", GHPullRequest.getLogins(reviewers))).withUrlPath(this.getApiRoute() + REQUEST_REVIEWERS, new String[0])).send();
    }

    public void requestTeamReviewers(List<GHTeam> teams) throws IOException {
        ArrayList<String> teamReviewers = new ArrayList<String>(teams.size());
        for (GHTeam team : teams) {
            teamReviewers.add(team.getSlug());
        }
        ((Requester)((Requester)((Requester)this.root().createRequest().method("POST")).with("team_reviewers", teamReviewers)).withUrlPath(this.getApiRoute() + REQUEST_REVIEWERS, new String[0])).send();
    }

    public GHPullRequest setBaseBranch(String newBaseBranch) throws IOException {
        return ((Requester)((Requester)((Requester)this.root().createRequest().method("PATCH")).with("base", newBaseBranch)).withUrlPath(this.getApiRoute(), new String[0])).fetch(GHPullRequest.class);
    }

    public void updateBranch() throws IOException {
        ((Requester)((Requester)((Requester)this.root().createRequest().method("PUT")).with("expected_head_sha", this.head.getSha())).withUrlPath(this.getApiRoute() + "/update-branch", new String[0])).send();
    }

    public void merge(String msg) throws IOException {
        this.merge(msg, null);
    }

    public void merge(String msg, String sha) throws IOException {
        this.merge(msg, sha, null);
    }

    public void merge(String msg, String sha, MergeMethod method) throws IOException {
        ((Requester)((Requester)((Requester)((Requester)((Requester)this.root().createRequest().method("PUT")).with("commit_message", msg)).with("sha", sha)).with("merge_method", method)).withUrlPath(this.getApiRoute() + "/merge", new String[0])).send();
    }

    public void enablePullRequestAutoMerge(String authorEmail, String clientMutationId, String commitBody, String commitHeadline, String expectedHeadOid, MergeMethod mergeMethod) throws IOException {
        StringBuilder inputBuilder = new StringBuilder();
        this.addParameter(inputBuilder, "pullRequestId", this.getNodeId());
        this.addOptionalParameter(inputBuilder, "authorEmail", authorEmail);
        this.addOptionalParameter(inputBuilder, "clientMutationId", clientMutationId);
        this.addOptionalParameter(inputBuilder, "commitBody", commitBody);
        this.addOptionalParameter(inputBuilder, "commitHeadline", commitHeadline);
        this.addOptionalParameter(inputBuilder, "expectedHeadOid", expectedHeadOid);
        this.addOptionalParameter(inputBuilder, "mergeMethod", (Object)mergeMethod);
        String graphqlBody = "mutation EnableAutoMerge { enablePullRequestAutoMerge(input: {" + String.valueOf(inputBuilder) + "}) { pullRequest { id } } }";
        this.root().createGraphQLRequest(graphqlBody).sendGraphQL();
        this.refresh();
    }

    private void addOptionalParameter(StringBuilder inputBuilder, String name, Object value) {
        if (value != null) {
            this.addParameter(inputBuilder, name, value);
        }
    }

    private void addParameter(StringBuilder inputBuilder, String name, Object value) {
        Objects.requireNonNull(value);
        String formatString = " %s: \"%s\"";
        if (value instanceof Enum) {
            formatString = " %s: %s";
        }
        inputBuilder.append(String.format(formatString, name, value));
    }

    @SuppressFBWarnings(value={"UWF_UNWRITTEN_FIELD"}, justification="Field comes from JSON deserialization")
    public static class AutoMerge {
        private GHUser enabledBy;
        private MergeMethod mergeMethod;
        private String commitTitle;
        private String commitMessage;

        @SuppressFBWarnings(value={"EI_EXPOSE_REP"}, justification="Expected behavior")
        public GHUser getEnabledBy() {
            return this.enabledBy;
        }

        public MergeMethod getMergeMethod() {
            return this.mergeMethod;
        }

        public String getCommitTitle() {
            return this.commitTitle;
        }

        public String getCommitMessage() {
            return this.commitMessage;
        }
    }

    public static enum MergeMethod {
        MERGE,
        SQUASH,
        REBASE;

    }
}

