/*
 * Decompiled with CFR 0.152.
 */
package org.kohsuke.github;

import com.fasterxml.jackson.databind.node.ObjectNode;
import com.infradna.tool.bridge_method_injector.WithBridgeMethods;
import edu.umd.cs.findbugs.annotations.SuppressFBWarnings;
import java.io.IOException;
import java.time.Instant;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.Map;
import org.kohsuke.github.GHEvent;
import org.kohsuke.github.GHEventPayload;
import org.kohsuke.github.GHOrganization;
import org.kohsuke.github.GHRepository;
import org.kohsuke.github.GHUser;
import org.kohsuke.github.GitHubClient;
import org.kohsuke.github.GitHubInteractiveObject;

@SuppressFBWarnings(value={"UWF_UNWRITTEN_PUBLIC_OR_PROTECTED_FIELD"}, justification="JSON API")
public class GHEventInfo
extends GitHubInteractiveObject {
    private ObjectNode payload;
    private long id;
    private String createdAt;
    private String type;
    private GHEventRepository repo;
    private GHUser actor;
    private GHOrganization org;
    static final Map<String, GHEvent> mapTypeStringToEvent = GHEventInfo.createEventMap();

    private static Map<String, GHEvent> createEventMap() {
        HashMap<String, GHEvent> map = new HashMap<String, GHEvent>();
        map.put("CommitCommentEvent", GHEvent.COMMIT_COMMENT);
        map.put("CreateEvent", GHEvent.CREATE);
        map.put("DeleteEvent", GHEvent.DELETE);
        map.put("ForkEvent", GHEvent.FORK);
        map.put("GollumEvent", GHEvent.GOLLUM);
        map.put("IssueCommentEvent", GHEvent.ISSUE_COMMENT);
        map.put("IssuesEvent", GHEvent.ISSUES);
        map.put("MemberEvent", GHEvent.MEMBER);
        map.put("PublicEvent", GHEvent.PUBLIC);
        map.put("PullRequestEvent", GHEvent.PULL_REQUEST);
        map.put("PullRequestReviewEvent", GHEvent.PULL_REQUEST_REVIEW);
        map.put("PullRequestReviewCommentEvent", GHEvent.PULL_REQUEST_REVIEW_COMMENT);
        map.put("PushEvent", GHEvent.PUSH);
        map.put("ReleaseEvent", GHEvent.RELEASE);
        map.put("WatchEvent", GHEvent.WATCH);
        return Collections.unmodifiableMap(map);
    }

    static GHEvent transformTypeToGHEvent(String type) {
        return mapTypeStringToEvent.getOrDefault(type, GHEvent.UNKNOWN);
    }

    public GHEvent getType() {
        return GHEventInfo.transformTypeToGHEvent(this.type);
    }

    public long getId() {
        return this.id;
    }

    @WithBridgeMethods(value={Date.class}, adapterMethod="instantToDate")
    public Instant getCreatedAt() {
        return GitHubClient.parseInstant(this.createdAt);
    }

    @SuppressFBWarnings(value={"UWF_FIELD_NOT_INITIALIZED_IN_CONSTRUCTOR"}, justification="The field comes from JSON deserialization")
    public GHRepository getRepository() throws IOException {
        return this.root().getRepository(this.repo.name);
    }

    @SuppressFBWarnings(value={"UWF_FIELD_NOT_INITIALIZED_IN_CONSTRUCTOR"}, justification="The field comes from JSON deserialization")
    public GHUser getActor() throws IOException {
        return this.root().getUser(this.actor.getLogin());
    }

    public String getActorLogin() {
        return this.actor.getLogin();
    }

    @SuppressFBWarnings(value={"UWF_FIELD_NOT_INITIALIZED_IN_CONSTRUCTOR"}, justification="The field comes from JSON deserialization")
    public GHOrganization getOrganization() throws IOException {
        return this.org == null || this.org.getLogin() == null ? null : this.root().getOrganization(this.org.getLogin());
    }

    public <T extends GHEventPayload> T getPayload(Class<T> type) throws IOException {
        GHEventPayload v = (GHEventPayload)GitHubClient.getMappingObjectReader(this.root()).readValue(this.payload.traverse(), type);
        v.lateBind();
        return (T)v;
    }

    @SuppressFBWarnings(value={"UWF_UNWRITTEN_PUBLIC_OR_PROTECTED_FIELD", "UWF_UNWRITTEN_FIELD", "UWF_FIELD_NOT_INITIALIZED_IN_CONSTRUCTOR"}, justification="JSON API")
    public static class GHEventRepository {
        @SuppressFBWarnings(value={"UUF_UNUSED_FIELD"}, justification="We don't provide it in API now")
        private long id;
        @SuppressFBWarnings(value={"UUF_UNUSED_FIELD"}, justification="We don't provide it in API now")
        private String url;
        private String name;
    }
}

