/*
 * Decompiled with CFR 0.152.
 */
package org.kohsuke.github;

import com.fasterxml.jackson.annotation.JacksonInject;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import edu.umd.cs.findbugs.annotations.SuppressFBWarnings;
import java.time.Duration;
import java.time.ZonedDateTime;
import java.time.format.DateTimeFormatter;
import java.time.format.DateTimeParseException;
import java.util.Date;
import java.util.Objects;
import java.util.concurrent.atomic.AtomicReference;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.annotation.CheckForNull;
import javax.annotation.Nonnull;
import org.apache.commons.lang3.StringUtils;
import org.kohsuke.github.RateLimitTarget;
import org.kohsuke.github.Requester;
import org.kohsuke.github.connector.GitHubConnectorResponse;

@SuppressFBWarnings(value={"URF_UNREAD_PUBLIC_OR_PROTECTED_FIELD"}, justification="JSON API")
public class GHRateLimit {
    @Nonnull
    private final Record core;
    @Nonnull
    private final Record search;
    @Nonnull
    private final Record graphql;
    @Nonnull
    private final Record integrationManifest;
    @Nonnull
    static final GHRateLimit DEFAULT = new GHRateLimit(UnknownLimitRecord.DEFAULT, UnknownLimitRecord.DEFAULT, UnknownLimitRecord.DEFAULT, UnknownLimitRecord.DEFAULT);
    private static final Logger LOGGER = Logger.getLogger(Requester.class.getName());

    @Nonnull
    static GHRateLimit fromRecord(@Nonnull Record record, @Nonnull RateLimitTarget rateLimitTarget) {
        if (rateLimitTarget == RateLimitTarget.CORE || rateLimitTarget == RateLimitTarget.NONE) {
            return new GHRateLimit(record, UnknownLimitRecord.DEFAULT, UnknownLimitRecord.DEFAULT, UnknownLimitRecord.DEFAULT);
        }
        if (rateLimitTarget == RateLimitTarget.SEARCH) {
            return new GHRateLimit(UnknownLimitRecord.DEFAULT, record, UnknownLimitRecord.DEFAULT, UnknownLimitRecord.DEFAULT);
        }
        if (rateLimitTarget == RateLimitTarget.GRAPHQL) {
            return new GHRateLimit(UnknownLimitRecord.DEFAULT, UnknownLimitRecord.DEFAULT, record, UnknownLimitRecord.DEFAULT);
        }
        if (rateLimitTarget == RateLimitTarget.INTEGRATION_MANIFEST) {
            return new GHRateLimit(UnknownLimitRecord.DEFAULT, UnknownLimitRecord.DEFAULT, UnknownLimitRecord.DEFAULT, record);
        }
        throw new IllegalArgumentException("Unknown rate limit target: " + rateLimitTarget.toString());
    }

    @JsonCreator
    GHRateLimit(@Nonnull @JsonProperty(value="core") Record core, @Nonnull @JsonProperty(value="search") Record search, @Nonnull @JsonProperty(value="graphql") Record graphql, @Nonnull @JsonProperty(value="integration_manifest") Record integrationManifest) {
        Objects.requireNonNull(core);
        Objects.requireNonNull(search);
        Objects.requireNonNull(graphql);
        Objects.requireNonNull(integrationManifest);
        this.core = core;
        this.search = search;
        this.graphql = graphql;
        this.integrationManifest = integrationManifest;
    }

    @Nonnull
    public Date getResetDate() {
        return this.getCore().getResetDate();
    }

    public int getRemaining() {
        return this.getCore().getRemaining();
    }

    public int getLimit() {
        return this.getCore().getLimit();
    }

    public long getResetEpochSeconds() {
        return this.getCore().getResetEpochSeconds();
    }

    public boolean isExpired() {
        return this.getCore().isExpired();
    }

    @Nonnull
    public Record getCore() {
        return this.core;
    }

    @Nonnull
    public Record getSearch() {
        return this.search;
    }

    @Nonnull
    public Record getGraphQL() {
        return this.graphql;
    }

    @Nonnull
    public Record getIntegrationManifest() {
        return this.integrationManifest;
    }

    public String toString() {
        return "GHRateLimit {core " + this.getCore().toString() + ", search " + this.getSearch().toString() + ", graphql " + this.getGraphQL().toString() + ", integrationManifest " + this.getIntegrationManifest().toString() + "}";
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        GHRateLimit rateLimit = (GHRateLimit)o;
        return this.getCore().equals(rateLimit.getCore()) && this.getSearch().equals(rateLimit.getSearch()) && this.getGraphQL().equals(rateLimit.getGraphQL()) && this.getIntegrationManifest().equals(rateLimit.getIntegrationManifest());
    }

    public int hashCode() {
        return Objects.hash(this.getCore(), this.getSearch(), this.getGraphQL(), this.getIntegrationManifest());
    }

    @Nonnull
    GHRateLimit getMergedRateLimit(@Nonnull GHRateLimit newLimit) {
        GHRateLimit merged = new GHRateLimit(this.getCore().currentOrUpdated(newLimit.getCore()), this.getSearch().currentOrUpdated(newLimit.getSearch()), this.getGraphQL().currentOrUpdated(newLimit.getGraphQL()), this.getIntegrationManifest().currentOrUpdated(newLimit.getIntegrationManifest()));
        if (merged.equals(this)) {
            merged = this;
        }
        return merged;
    }

    @Nonnull
    Record getRecord(@Nonnull RateLimitTarget rateLimitTarget) {
        if (rateLimitTarget == RateLimitTarget.CORE) {
            return this.getCore();
        }
        if (rateLimitTarget == RateLimitTarget.SEARCH) {
            return this.getSearch();
        }
        if (rateLimitTarget == RateLimitTarget.GRAPHQL) {
            return this.getGraphQL();
        }
        if (rateLimitTarget == RateLimitTarget.INTEGRATION_MANIFEST) {
            return this.getIntegrationManifest();
        }
        if (rateLimitTarget == RateLimitTarget.NONE) {
            return UnknownLimitRecord.DEFAULT;
        }
        throw new IllegalArgumentException("Unknown rate limit target: " + rateLimitTarget.toString());
    }

    public static class UnknownLimitRecord
    extends Record {
        private static final long defaultUnknownLimitResetSeconds;
        static long unknownLimitResetSeconds;
        static final int unknownLimit = 1000000;
        static final int unknownRemaining = 999999;
        private static final UnknownLimitRecord DEFAULT;
        private static final AtomicReference<UnknownLimitRecord> current;

        private UnknownLimitRecord(long resetEpochSeconds) {
            super(1000000, 999999, resetEpochSeconds);
        }

        static Record current() {
            Record result = current.get();
            if (result.isExpired()) {
                current.set(new UnknownLimitRecord(System.currentTimeMillis() / 1000L + unknownLimitResetSeconds));
                result = current.get();
            }
            return result;
        }

        static void reset() {
            current.set(DEFAULT);
            unknownLimitResetSeconds = defaultUnknownLimitResetSeconds;
        }

        static {
            unknownLimitResetSeconds = defaultUnknownLimitResetSeconds = Duration.ofSeconds(30L).getSeconds();
            DEFAULT = new UnknownLimitRecord(Long.MIN_VALUE);
            current = new AtomicReference<UnknownLimitRecord>(DEFAULT);
        }
    }

    public static class Record {
        private final int remaining;
        private final int limit;
        private final long resetEpochSeconds;
        private final long createdAtEpochSeconds = System.currentTimeMillis() / 1000L;
        @Nonnull
        private final Date resetDate;

        public Record(@JsonProperty(value="limit", required=true) int limit, @JsonProperty(value="remaining", required=true) int remaining, @JsonProperty(value="reset", required=true) long resetEpochSeconds) {
            this(limit, remaining, resetEpochSeconds, null);
        }

        @JsonCreator
        Record(@JsonProperty(value="limit", required=true) int limit, @JsonProperty(value="remaining", required=true) int remaining, @JsonProperty(value="reset", required=true) long resetEpochSeconds, @JacksonInject @CheckForNull GitHubConnectorResponse connectorResponse) {
            this.limit = limit;
            this.remaining = remaining;
            this.resetEpochSeconds = resetEpochSeconds;
            String updatedAt = null;
            if (connectorResponse != null) {
                updatedAt = connectorResponse.header("Date");
            }
            this.resetDate = this.calculateResetDate(updatedAt);
        }

        Record currentOrUpdated(@Nonnull Record other) {
            if (this.getResetEpochSeconds() > other.getResetEpochSeconds() || this.getResetEpochSeconds() == other.getResetEpochSeconds() && this.getRemaining() <= other.getRemaining()) {
                return this;
            }
            if (!(other instanceof UnknownLimitRecord)) {
                return other;
            }
            if (this.isExpired() && !other.isExpired()) {
                return other;
            }
            return this;
        }

        @Nonnull
        private Date calculateResetDate(@CheckForNull String updatedAt) {
            long updatedAtEpochSeconds;
            block3: {
                updatedAtEpochSeconds = this.createdAtEpochSeconds;
                if (!StringUtils.isBlank((CharSequence)updatedAt)) {
                    try {
                        updatedAtEpochSeconds = ZonedDateTime.parse(updatedAt, DateTimeFormatter.RFC_1123_DATE_TIME).toEpochSecond();
                    }
                    catch (DateTimeParseException e) {
                        if (!LOGGER.isLoggable(Level.FINEST)) break block3;
                        LOGGER.log(Level.FINEST, "Malformed Date header value " + updatedAt, e);
                    }
                }
            }
            long calculatedSecondsUntilReset = this.resetEpochSeconds - updatedAtEpochSeconds;
            return new Date((this.createdAtEpochSeconds + calculatedSecondsUntilReset) * 1000L);
        }

        public int getRemaining() {
            return this.remaining;
        }

        public int getLimit() {
            return this.limit;
        }

        public long getResetEpochSeconds() {
            return this.resetEpochSeconds;
        }

        public boolean isExpired() {
            return this.getResetDate().getTime() < System.currentTimeMillis();
        }

        @Nonnull
        public Date getResetDate() {
            return new Date(this.resetDate.getTime());
        }

        public String toString() {
            return "{remaining=" + this.getRemaining() + ", limit=" + this.getLimit() + ", resetDate=" + this.getResetDate() + "}";
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            Record record = (Record)o;
            return this.getRemaining() == record.getRemaining() && this.getLimit() == record.getLimit() && this.getResetEpochSeconds() == record.getResetEpochSeconds() && this.getResetDate().equals(record.getResetDate());
        }

        public int hashCode() {
            return Objects.hash(this.getRemaining(), this.getLimit(), this.getResetEpochSeconds(), this.getResetDate());
        }
    }
}

